<?php
/**
 * Header/Footer Builder
 * Search Component
 * 
 * @package Botiga_Pro
 */

/**
 * Tabs
 */

$general_options = json_decode( $wp_customize->get_control( 'botiga_section_hb_component__search_tabs' )->controls_general );
$wp_customize->get_control( 'botiga_section_hb_component__search_tabs' )->controls_general = json_encode(
    array_merge(
        $general_options,
        array(
            '#customize-control-bhfb_search_layout',
            '#customize-control-bhfb_search_form_button_icon',
            '#customize-control-bhfb_search_form_button_icon_custom_image',
            '#customize-control-bhfb_search_form_size',
            '#customize-control-bhfb_search_form_width',
            '#customize-control-bhfb_search_divider1',
            '#customize-control-bhfb_search_product_categories_dropdown',
            '#customize-control-bhfb_search_product_categories_dropdown_exclude',
			'#customize-control-bhfb_search_product_categories_dropdown_hide_mobile'
        ) 
    )
);

$design_options = json_decode( $wp_customize->get_control( 'botiga_section_hb_component__search_tabs' )->controls_design );
$wp_customize->get_control( 'botiga_section_hb_component__search_tabs' )->controls_design = json_encode(
    array_merge(
        $design_options,
        array(
            '#customize-control-bhfb_search_form_wrapper_title',
            '#customize-control-bhfb_search_form_wrapper_background_color',
            '#customize-control-bhfb_search_form_input_background_color',
            '#customize-control-bhfb_search_form_input_border_color',
            '#customize-control-bhfb_search_form_input_text_color',
            '#customize-control-bhfb_search_form_input_placeholder_color',
            '#customize-control-bhfb_search_form_input_border_radius',
            '#customize-control-bhfb_search_form_button_background',
            '#customize-control-bhfb_search_form_button_border',
            '#customize-control-bhfb_search_form_button_text',
            '#customize-control-bhfb_search_form_button_border_radius',
            '#customize-control-bhfb_search_form_button_margin_left',
            '#customize-control-bhfb_search_divider2',
            '#customize-control-bhfb_search_product_cat_dropdown_title',
            '#customize-control-bhfb_search_form_product_cat_dropdown_margin_right'
        ) 
    )
);

/**
 * General (tab)
 */

// Search Layout Type
$wp_customize->add_setting( 
	'bhfb_search_layout', 
	array(
		'default'           => 'hidden',
		'sanitize_callback' => 'botiga_sanitize_select',
	) 
);
$wp_customize->add_control( 
	'bhfb_search_layout', 
	array(
		'type'      => 'select',
		'section'   => 'botiga_section_hb_component__search',
		'label'     => esc_html__( 'Layout Type', 'botiga-pro' ),
		'choices'   => array(
			'hidden' => esc_html__( 'Search Form Hidden', 'botiga-pro' ),
			'visible'    => esc_html__( 'Search Form Visible', 'botiga-pro' )
		),
		'priority'  => 20,
	)
);

// Search Icon
// add callback to the option
$wp_customize->get_control( 'search_icon' )->active_callback = 'botiga_bhfb_search_layout_is_hidden';
$wp_customize->get_control( 'search_icon' )->priority        = 21;

// Search Icon Custom Image
// change priority
$wp_customize->get_control( 'search_icon_custom_image' )->priority = 21;

// Search Form Button Icon
$wp_customize->add_setting(
    'bhfb_search_form_button_icon',
    array(
        'default'           => 'icon-search',
        'sanitize_callback' => 'sanitize_key',
    )
);
$wp_customize->add_control(
    new Botiga_Radio_Images(
        $wp_customize,
        'bhfb_search_form_button_icon',
        array(
            'label'    	=> esc_html__( 'Search Form Button Icon', 'botiga-pro' ),
            'section'  	=> 'botiga_section_hb_component__search',
            'cols'		=> 4,
            'choices'  	=> array(			
                'icon-search'  => array(
                    'label'  => esc_html__( 'Icon 1', 'botiga-pro' ),
                    'url'    => '%s/assets/img/search-icon1.svg'
                ),
                'icon-custom' => array(
                    'label'  => esc_html__( 'Custom Icon', 'botiga-pro' ),
                    'url'    => '%s/assets/img/upload-custom-icon.svg'
                )
            ),
            'priority'		  => 21
        )
    )
);

// Search Form Button Icon Custom Image
$wp_customize->add_setting( 
    'bhfb_search_form_button_icon_custom_image',
    array(
        'default'           => '',
        'sanitize_callback' => 'absint',
    ) 
);
$wp_customize->add_control( 
    new WP_Customize_Media_Control( 
        $wp_customize, 
        'bhfb_search_form_button_icon_custom_image',
        array(
            'label'           => '',
            'section'         => 'botiga_section_hb_component__search',
            'mime_type'       => 'image',
            'active_callback' => function() { return 'icon-custom' === get_theme_mod( 'bhfb_search_form_button_icon', 'icon-search' ); },
            'priority'	      => 21
        )
    )
);

// Search Form Size
$wp_customize->add_setting( 'bhfb_search_form_size', array(
	'default'   		=> 1,
	'sanitize_callback' => 'botiga_sanitize_text',
    'transport'         => 'postMessage'
) );			
$wp_customize->add_control( new Botiga_Responsive_Slider( $wp_customize, 'bhfb_search_form_size',
	array(
		'label' 		=> esc_html__( 'Search Form Size', 'botiga-pro' ),
		'section' 		=> 'botiga_section_hb_component__search',
		'is_responsive'	=> 0,
		'settings' 		=> array (
			'size_desktop' 		=> 'bhfb_search_form_size',
		),
		'input_attrs' => array (
			'min'  => 0.8,
			'max'  => 2.2,
			'step' => 0.1,
			'unit' => 'rem',
        ),
        'priority'		  => 21
	)
) );

// Search Form Width
$wp_customize->add_setting( 'bhfb_search_form_width_desktop', array(
	'default'   		=> 320,
	'sanitize_callback' => 'botiga_sanitize_text',
    'transport'         => 'postMessage'
) );
$wp_customize->add_setting( 'bhfb_search_form_width_tablet', array(
	'default'   		=> 320,
	'sanitize_callback' => 'botiga_sanitize_text',
    'transport'         => 'postMessage'
) );
$wp_customize->add_setting( 'bhfb_search_form_width_mobile', array(
	'default'   		=> 200,
	'sanitize_callback' => 'botiga_sanitize_text',
    'transport'         => 'postMessage'
) );			
$wp_customize->add_control( new Botiga_Responsive_Slider( $wp_customize, 'bhfb_search_form_width',
	array(
		'label' 		=> esc_html__( 'Search Form Width', 'botiga-pro' ),
		'section' 		=> 'botiga_section_hb_component__search',
		'is_responsive'	=> 1,
		'settings' 		=> array (
			'size_desktop' 		=> 'bhfb_search_form_width_desktop',
            'size_tablet' 		=> 'bhfb_search_form_width_tablet',
            'size_mobile' 		=> 'bhfb_search_form_width_mobile',
		),
		'input_attrs' => array (
			'min'  => 0,
			'max'  => 600,
			'step' => 1,
			'unit' => 'px',
        ),
        'active_callback' => 'botiga_bhfb_search_layout_is_visible',
        'priority'		  => 21
	)
) );

// Divider
$wp_customize->add_setting( 'bhfb_search_divider1',
	array(
		'sanitize_callback' => 'esc_attr'
	)
);
$wp_customize->add_control( new Botiga_Divider_Control( $wp_customize, 'bhfb_search_divider1',
		array(
			'section' 		=> 'botiga_section_hb_component__search',
			'priority'		=> 21
		)
	)
);

// Display Product Categories Dropdown
$wp_customize->add_setting(
	'bhfb_search_product_categories_dropdown',
	array(
		'default'           => 0,
		'sanitize_callback' => 'botiga_sanitize_checkbox',
	)
);
$wp_customize->add_control(
	new Botiga_Toggle_Control(
		$wp_customize,
		'bhfb_search_product_categories_dropdown',
		array(
			'label'         	=> esc_html__( 'Product Categories Dropdown', 'botiga-pro' ),
			'section'       	=> 'botiga_section_hb_component__search',
			'priority'		    => 21
		)
	)
);

// Product Categories Dropdown Exclude
$wp_customize->add_setting(
	'bhfb_search_product_categories_dropdown_exclude',
	array(
		'sanitize_callback' => 'esc_attr',
		'default'           => '',
	)       
);
$wp_customize->add_control( 'bhfb_search_product_categories_dropdown_exclude', array(
	'label'             => esc_html__( 'Exclude Categories From Dropdown', 'botiga-pro' ),
    'description'       => esc_html__( 'Comma/space-separated string of product category IDs to exclude.', 'botiga-pro' ),
	'type'              => 'text',
	'section'           => 'botiga_section_hb_component__search',
	'active_callback'   => function(){ return true == get_theme_mod( 'bhfb_search_product_categories_dropdown', 0 ); },
	'priority'			=> 21
) );

// Hide Dropdown On Mobile
$wp_customize->add_setting(
	'bhfb_search_product_categories_dropdown_hide_mobile',
	array(
		'default'           => 1,
		'sanitize_callback' => 'botiga_sanitize_checkbox',
	)
);
$wp_customize->add_control(
	new Botiga_Toggle_Control(
		$wp_customize,
		'bhfb_search_product_categories_dropdown_hide_mobile',
		array(
			'label'         	=> esc_html__( 'Hide Drodown On Mobile', 'botiga-pro' ),
			'section'       	=> 'botiga_section_hb_component__search',
			'priority'		    => 21
		)
	)
);

/**
 * Style (tab)
 */

// Search Icon Color
// add active callback
$wp_customize->get_control( 'bhfb_search_icon' )->active_callback = 'botiga_bhfb_search_layout_is_hidden';

// Search Form Wrapper Title
$wp_customize->add_setting( 'bhfb_search_form_wrapper_title',
	array(
		'default' 			=> '',
		'sanitize_callback' => 'esc_attr'
	)
);
$wp_customize->add_control( new Botiga_Text_Control( $wp_customize, 'bhfb_search_form_wrapper_title',
		array(
			'label'			=> esc_html__( 'Search Form', 'botiga-pro' ),
			'section' 		=> 'botiga_section_hb_component__search',
			'priority'		=> 30
		)
	)
);

// Search Form Wrapper Background Color
$wp_customize->add_setting(
	'bhfb_search_form_wrapper_background_color',
	array(
		'default'           => '#FFF',
		'sanitize_callback' => 'botiga_sanitize_hex_rgba',
		'transport'         => 'postMessage'
	)
);
$wp_customize->add_control(
    new Botiga_Color_Group(
        $wp_customize,
        'bhfb_search_form_wrapper_background_color',
        array(
            'label'    => esc_html__( 'Wrapper Background Color', 'botiga-pro' ),
            'section'  => 'botiga_section_hb_component__search',
            'settings' => array(
                'normal' => 'bhfb_search_form_wrapper_background_color'
            ),
            'active_callback' => 'botiga_bhfb_search_layout_is_hidden',
            'priority' => 30
        )
    )
);

// Search Form Input Background Color
$wp_customize->add_setting(
	'bhfb_search_form_input_background_color',
	array(
		'default'           => '#FFFFFF',
		'sanitize_callback' => 'botiga_sanitize_hex_rgba',
		'transport'         => 'postMessage'
	)
);
$wp_customize->add_control(
    new Botiga_Color_Group(
        $wp_customize,
        'bhfb_search_form_input_background_color',
        array(
            'label'    => esc_html__( 'Input Background Color', 'botiga-pro' ),
            'section'  => 'botiga_section_hb_component__search',
            'settings' => array(
                'normal' => 'bhfb_search_form_input_background_color'
            ),
            'priority' => 30
        )
    )
);

// Search Form Input Border Color
$wp_customize->add_setting(
	'bhfb_search_form_input_border_color',
	array(
		'default'           => '#212121',
		'sanitize_callback' => 'botiga_sanitize_hex_rgba',
		'transport'         => 'postMessage'
	)
);
$wp_customize->add_control(
    new Botiga_Color_Group(
        $wp_customize,
        'bhfb_search_form_input_border_color',
        array(
            'label'    => esc_html__( 'Input Border Color', 'botiga-pro' ),
            'section'  => 'botiga_section_hb_component__search',
            'settings' => array(
                'normal' => 'bhfb_search_form_input_border_color'
            ),
            'priority' => 30
        )
    )
);

// Search Form input Text Color
$wp_customize->add_setting(
	'bhfb_search_form_input_text_color',
	array(
		'default'           => '#212121',
		'sanitize_callback' => 'botiga_sanitize_hex_rgba',
		'transport'         => 'postMessage'
	)
);
$wp_customize->add_control(
    new Botiga_Color_Group(
        $wp_customize,
        'bhfb_search_form_input_text_color',
        array(
            'label'    => esc_html__( 'Input Text Color', 'botiga-pro' ),
            'section'  => 'botiga_section_hb_component__search',
            'settings' => array(
                'normal' => 'bhfb_search_form_input_text_color'
            ),
            'priority' => 30
        )
    )
);

// Search Form Input Placeholder Color
$wp_customize->add_setting(
	'bhfb_search_form_input_placeholder_color',
	array(
		'default'           => '#777',
		'sanitize_callback' => 'botiga_sanitize_hex_rgba',
		'transport'         => 'postMessage'
	)
);
$wp_customize->add_control(
    new Botiga_Color_Group(
        $wp_customize,
        'bhfb_search_form_input_placeholder_color',
        array(
            'label'    => esc_html__( 'Input Placeholder Color', 'botiga-pro' ),
            'section'  => 'botiga_section_hb_component__search',
            'settings' => array(
                'normal' => 'bhfb_search_form_input_placeholder_color'
            ),
            'priority' => 30
        )
    )
);

// Search Form Input Border Radius
$wp_customize->add_setting( 'bhfb_search_form_input_border_radius', array(
	'default'   		=> 0,
	'sanitize_callback' => 'botiga_sanitize_text',
    'transport'         => 'postMessage'
) );			
$wp_customize->add_control( new Botiga_Responsive_Slider( $wp_customize, 'bhfb_search_form_input_border_radius',
	array(
		'label' 		=> esc_html__( 'Input Border Radius', 'botiga-pro' ),
        'title_font_size'      => 'normal',
        'title_weight'         => 'normal',
        'title_text_transform' => 'none',
		'section' 		=> 'botiga_section_hb_component__search',
		'is_responsive'	=> 0,
		'settings' 		=> array (
			'size_desktop' 		=> 'bhfb_search_form_input_border_radius',
		),
		'input_attrs' => array (
			'min'  => 0,
			'max'  => 35,
			'step' => 1,
			'unit' => 'px',
        ),
        'priority'		  => 30
	)
) );

// Search Form Button Background (normal/hover)
$wp_customize->add_setting(
	'bhfb_search_form_button_background_color',
	array(
		'default'           => '#212121',
		'sanitize_callback' => 'botiga_sanitize_hex_rgba',
		'transport'         => 'postMessage'
	)
);
$wp_customize->add_setting(
	'bhfb_search_form_button_background_color_hover',
	array(
		'default'           => '#757575',
		'sanitize_callback' => 'botiga_sanitize_hex_rgba',
		'transport'         => 'postMessage'
	)
);
$wp_customize->add_control(
    new Botiga_Color_Group(
        $wp_customize,
        'bhfb_search_form_button_background',
        array(
            'label'    => esc_html__( 'Button Background Color', 'botiga-pro' ),
            'section'  => 'botiga_section_hb_component__search',
            'settings' => array(
                'normal' => 'bhfb_search_form_button_background_color',
                'hover'  => 'bhfb_search_form_button_background_color_hover'
            ),
            'priority' => 30
        )
    )
);

// Search Form Button Border (normal/hover)
$wp_customize->add_setting(
	'bhfb_search_form_button_border_color',
	array(
		'default'           => '#212121',
		'sanitize_callback' => 'botiga_sanitize_hex_rgba',
		'transport'         => 'postMessage'
	)
);
$wp_customize->add_setting(
	'bhfb_search_form_button_border_color_hover',
	array(
		'default'           => '#757575',
		'sanitize_callback' => 'botiga_sanitize_hex_rgba',
		'transport'         => 'postMessage'
	)
);
$wp_customize->add_control(
    new Botiga_Color_Group(
        $wp_customize,
        'bhfb_search_form_button_border',
        array(
            'label'    => esc_html__( 'Button Border Color', 'botiga-pro' ),
            'section'  => 'botiga_section_hb_component__search',
            'settings' => array(
                'normal' => 'bhfb_search_form_button_border_color',
                'hover'  => 'bhfb_search_form_button_border_color_hover'
            ),
            'priority' => 30
        )
    )
);

// Search Form Button Text Color (normal/hover)
$wp_customize->add_setting(
	'bhfb_search_form_button_text_color',
	array(
		'default'           => '#FFFFFF',
		'sanitize_callback' => 'botiga_sanitize_hex_rgba',
		'transport'         => 'postMessage'
	)
);
$wp_customize->add_setting(
	'bhfb_search_form_button_text_color_hover',
	array(
		'default'           => '#FFFFFF',
		'sanitize_callback' => 'botiga_sanitize_hex_rgba',
		'transport'         => 'postMessage'
	)
);
$wp_customize->add_control(
    new Botiga_Color_Group(
        $wp_customize,
        'bhfb_search_form_button_text',
        array(
            'label'    => esc_html__( 'Button Text Color', 'botiga-pro' ),
            'section'  => 'botiga_section_hb_component__search',
            'settings' => array(
                'normal' => 'bhfb_search_form_button_text_color',
                'hover'  => 'bhfb_search_form_button_text_color_hover'
            ),
            'priority' => 30
        )
    )
);

// Search Form Button Border Radius
$wp_customize->add_setting( 'bhfb_search_form_button_border_radius', array(
	'default'   		=> 0,
	'sanitize_callback' => 'botiga_sanitize_text',
    'transport'         => 'postMessage'
) );			
$wp_customize->add_control( new Botiga_Responsive_Slider( $wp_customize, 'bhfb_search_form_button_border_radius',
	array(
		'label' 		=> esc_html__( 'Button Border Radius', 'botiga-pro' ),
        'title_font_size'      => 'normal',
        'title_weight'         => 'normal',
        'title_text_transform' => 'none',
		'section' 		=> 'botiga_section_hb_component__search',
		'is_responsive'	=> 0,
		'settings' 		=> array (
			'size_desktop' 		=> 'bhfb_search_form_button_border_radius',
		),
		'input_attrs' => array (
			'min'  => 0,
			'max'  => 35,
			'step' => 1,
			'unit' => 'px',
        ),
        'priority'		  => 30
	)
) );

// Search Form Button Margin Left
$wp_customize->add_setting( 'bhfb_search_form_button_margin_left', array(
	'default'   		=> 10,
	'sanitize_callback' => 'botiga_sanitize_text',
    'transport'         => 'postMessage'
) );			
$wp_customize->add_control( new Botiga_Responsive_Slider( $wp_customize, 'bhfb_search_form_button_margin_left',
	array(
		'label' 		=> esc_html__( 'Button Margin Left', 'botiga-pro' ),
        'description'   => esc_html__( 'Tip: Try negative values to have the button over the search input.', 'botiga-pro' ),
        'title_font_size'      => 'normal',
        'title_weight'         => 'normal',
        'title_text_transform' => 'none',
		'section' 		=> 'botiga_section_hb_component__search',
		'is_responsive'	=> 0,
		'settings' 		=> array (
			'size_desktop' 		=> 'bhfb_search_form_button_margin_left',
		),
		'input_attrs' => array (
			'min'  => -100,
			'max'  => 100,
			'step' => 1,
			'unit' => 'px',
        ),
        'priority'		  => 30
	)
) );

// Divider
$wp_customize->add_setting( 'bhfb_search_divider2',
	array(
		'sanitize_callback' => 'esc_attr'
	)
);
$wp_customize->add_control( new Botiga_Divider_Control( $wp_customize, 'bhfb_search_divider2',
		array(
			'section' 		  => 'botiga_section_hb_component__search',
            'active_callback' => function(){ return true == get_theme_mod( 'bhfb_search_product_categories_dropdown', 0 ); },
			'priority'		  => 30
		)
	)
);

// Product Categories Dropdown Title
$wp_customize->add_setting( 'bhfb_search_product_cat_dropdown_title',
	array(
		'default' 			=> '',
		'sanitize_callback' => 'esc_attr'
	)
);
$wp_customize->add_control( new Botiga_Text_Control( $wp_customize, 'bhfb_search_product_cat_dropdown_title',
		array(
			'label'			  => esc_html__( 'Product Categories Dropdown', 'botiga-pro' ),
			'section' 		  => 'botiga_section_hb_component__search',
            'active_callback' => function(){ return true == get_theme_mod( 'bhfb_search_product_categories_dropdown', 0 ); },
			'priority'		  => 30
		)
	)
);

// Product Categories Dropdown Margin Right
$wp_customize->add_setting( 'bhfb_search_form_product_cat_dropdown_margin_right', array(
	'default'   		=> 10,
	'sanitize_callback' => 'botiga_sanitize_text',
    'transport'         => 'postMessage'
) );			
$wp_customize->add_control( new Botiga_Responsive_Slider( $wp_customize, 'bhfb_search_form_product_cat_dropdown_margin_right',
	array(
		'label' 		=> esc_html__( 'Dropdown Margin Right', 'botiga-pro' ),
        'title_font_size'      => 'normal',
        'title_weight'         => 'normal',
        'title_text_transform' => 'none',
		'section' 		=> 'botiga_section_hb_component__search',
		'is_responsive'	=> 0,
		'settings' 		=> array (
			'size_desktop' 		=> 'bhfb_search_form_product_cat_dropdown_margin_right',
		),
		'input_attrs' => array (
			'min'  => -100,
			'max'  => 100,
			'step' => 1,
			'unit' => 'px',
        ),
        'active_callback' => function(){ return true == get_theme_mod( 'bhfb_search_product_categories_dropdown', 0 ); },
        'priority'		  => 30
	)
) );