<?php
/**
 * Header/Footer Builder
 * Polylang Components
 * 
 * @package Botiga_Pro
 */

/**
 * Polylang Language Switcher
 * 
 */
$wp_customize->add_section(
    'botiga_section_hb_component__pll_switcher',
    array(
        'title'      => esc_html__( 'Polylang Language Switcher', 'botiga-pro' ),
        'panel'      => 'botiga_panel_header'
    )
);

$wp_customize->add_setting(
	'botiga_section_hb_component__pll_switcher_show_flags',
	array(
		'default'           => 1,
		'sanitize_callback' => 'botiga_sanitize_checkbox',
	)
);
$wp_customize->add_control(
	new Botiga_Toggle_Control(
		$wp_customize,
		'botiga_section_hb_component__pll_switcher_show_flags',
		array(
			'label'         	=> esc_html__( 'Show flags', 'botiga-pro' ),
			'section'       	=> 'botiga_section_hb_component__pll_switcher',
            'priority' 			=> 30
		)
	)
);

$wp_customize->add_setting(
	'botiga_section_hb_component__pll_switcher_show_names',
	array(
		'default'           => 0,
		'sanitize_callback' => 'botiga_sanitize_checkbox',
	)
);
$wp_customize->add_control(
	new Botiga_Toggle_Control(
		$wp_customize,
		'botiga_section_hb_component__pll_switcher_show_names',
		array(
			'label'         	=> esc_html__( 'Show names', 'botiga-pro' ),
			'section'       	=> 'botiga_section_hb_component__pll_switcher',
            'priority' 			=> 35
		)
	)
);

$wp_customize->add_setting(
	'botiga_section_hb_component__pll_switcher_dropdown',
	array(
		'default'           => 0,
		'sanitize_callback' => 'botiga_sanitize_checkbox',
	)
);
$wp_customize->add_control(
	new Botiga_Toggle_Control(
		$wp_customize,
		'botiga_section_hb_component__pll_switcher_dropdown',
		array(
			'label'         	=> esc_html__( 'Show as dropdown', 'botiga-pro' ),
			'section'       	=> 'botiga_section_hb_component__pll_switcher',
            'priority' 			=> 40
		)
	)
);

$wp_customize->add_setting(
	'botiga_section_hb_component__pll_switcher_hide_current',
	array(
		'default'           => 0,
		'sanitize_callback' => 'botiga_sanitize_checkbox',
	)
);
$wp_customize->add_control(
	new Botiga_Toggle_Control(
		$wp_customize,
		'botiga_section_hb_component__pll_switcher_hide_current',
		array(
			'label'         	=> esc_html__( 'Hide current language', 'botiga-pro' ),
			'section'       	=> 'botiga_section_hb_component__pll_switcher',
            'priority' 			=> 45
		)
	)
);

// Visibility
$wp_customize->add_setting( 
    'botiga_section_hb_component__pll_switcher_visibility_desktop',
    array(
        'default' 			=> 'visible',
        'sanitize_callback' => 'botiga_sanitize_text',
        'transport'         => 'postMessage'
    )
);
$wp_customize->add_setting( 
    'botiga_section_hb_component__pll_switcher_visibility_tablet',
    array(
        'default' 			=> 'visible',
        'sanitize_callback' => 'botiga_sanitize_text',
        'transport'         => 'postMessage'
    )
);
$wp_customize->add_setting( 
    'botiga_section_hb_component__pll_switcher_visibility_mobile',
    array(
        'default' 			=> 'visible',
        'sanitize_callback' => 'botiga_sanitize_text',
        'transport'         => 'postMessage'
    )
);
$wp_customize->add_control( 
    new Botiga_Radio_Buttons( 
        $wp_customize, 
        'botiga_section_hb_component__pll_switcher_visibility',
        array(
            'label'         => esc_html__( 'Visibility', 'botiga' ),
            'section'       => 'botiga_section_hb_component__pll_switcher',
            'is_responsive' => true,
            'settings' => array(
                'desktop' 		=> 'botiga_section_hb_component__pll_switcher_visibility_desktop',
                'tablet' 		=> 'botiga_section_hb_component__pll_switcher_visibility_tablet',
                'mobile' 		=> 'botiga_section_hb_component__pll_switcher_visibility_mobile'
            ),
            'choices'       => array(
                'visible' => esc_html__( 'Visible', 'botiga' ),
                'hidden'  => esc_html__( 'Hidden', 'botiga' )
            ),
            'priority'      => 50
        )
    ) 
);

if( class_exists( 'Botiga_Dimensions_Control' ) ) {

    // Padding
    $wp_customize->add_setting( 
        'botiga_section_hb_component__pll_switcher_desktop',
        array(
            'default'           => '{ "unit": "px", "linked": false, "top": "", "right": "", "bottom": "", "left": "" }',
            'sanitize_callback' => 'botiga_sanitize_text',
            'transport'         => 'postMessage'
        ) 
    );
    $wp_customize->add_setting( 
        'botiga_section_hb_component__pll_switcher_tablet',
        array(
            'default'           => '{ "unit": "px", "linked": false, "top": "", "right": "", "bottom": "", "left": "" }',
            'sanitize_callback' => 'botiga_sanitize_text',
            'transport'         => 'postMessage'
        ) 
    );
    $wp_customize->add_setting( 
        'botiga_section_hb_component__pll_switcher_mobile',
        array(
            'default'           => '{ "unit": "px", "linked": false, "top": "", "right": "", "bottom": "", "left": "" }',
            'sanitize_callback' => 'botiga_sanitize_text',
            'transport'         => 'postMessage'
        ) 
    );
    $wp_customize->add_control( 
        new Botiga_Dimensions_Control( 
            $wp_customize, 
            'botiga_section_hb_component__pll_switcher',
            array(
                'label'           	=> __( 'Wrapper Padding', 'botiga' ),
                'section'         	=> 'botiga_section_hb_component__pll_switcher',
                'sides'             => array(
                    'top'    => true,
                    'right'  => true,
                    'bottom' => true,
                    'left'   => true
                ),
                'units'              => array( 'px', '%', 'rem', 'em', 'vw', 'vh' ),
                'link_values_toggle' => true,
                'is_responsive'   	 => true,
                'settings'        	 => array(
                    'desktop' => 'botiga_section_hb_component__pll_switcher_desktop',
                    'tablet'  => 'botiga_section_hb_component__pll_switcher_tablet',
                    'mobile'  => 'botiga_section_hb_component__pll_switcher_mobile'
                ),
                'priority'	      	 => 72
            )
        )
    );

    // Margin
    $wp_customize->add_setting( 
        'bhfb_button2_margin_desktop',
        array(
            'default'           => '{ "unit": "px", "linked": false, "top": "", "right": "", "bottom": "", "left": "" }',
            'sanitize_callback' => 'botiga_sanitize_text',
            'transport'         => 'postMessage'
        ) 
    );
    $wp_customize->add_setting( 
        'bhfb_button2_margin_tablet',
        array(
            'default'           => '{ "unit": "px", "linked": false, "top": "", "right": "", "bottom": "", "left": "" }',
            'sanitize_callback' => 'botiga_sanitize_text',
            'transport'         => 'postMessage'
        ) 
    );
    $wp_customize->add_setting( 
        'bhfb_button2_margin_mobile',
        array(
            'default'           => '{ "unit": "px", "linked": false, "top": "", "right": "", "bottom": "", "left": "" }',
            'sanitize_callback' => 'botiga_sanitize_text',
            'transport'         => 'postMessage'
        ) 
    );
    $wp_customize->add_control( 
        new Botiga_Dimensions_Control( 
            $wp_customize, 
            'bhfb_button2_margin',
            array(
                'label'           	=> __( 'Wrapper Margin', 'botiga' ),
                'section'         	=> 'botiga_section_hb_component__pll_switcher',
                'sides'             => array(
                    'top'    => true,
                    'right'  => true,
                    'bottom' => true,
                    'left'   => true
                ),
                'units'              => array( 'px', '%', 'rem', 'em', 'vw', 'vh' ),
                'link_values_toggle' => true,
                'is_responsive'   	 => true,
                'settings'        	 => array(
                    'desktop' => 'bhfb_button2_margin_desktop',
                    'tablet'  => 'bhfb_button2_margin_tablet',
                    'mobile'  => 'bhfb_button2_margin_mobile'
                ),
                'priority'	      	 => 72
            )
        )
    );

}