<?php 
/**
* Custom Sidebars Customizer Options
*/
$wp_customize->add_section(
    'botiga_section_sidebar',
    array(
        'title'    => esc_html__( 'Sidebar', 'botiga-pro' ),
        'priority' => 30,
    )
);

$wp_customize->add_setting( 'custom_sidebars',
    array(
        'default'           => '[]',
        'sanitize_callback' => 'sanitize_textarea_field'
    )
);
$wp_customize->add_control(
    new Botiga_Custom_Sidebars_Control(
        $wp_customize,
        'custom_sidebars',
        array(
            'label'   => esc_html__( 'Custom Sidebars', 'botiga-pro' ),
            'section' => 'botiga_section_sidebar',
        )
    )
);

$wp_customize->add_setting(
    'custom_sidebars_learn_more',
    array(
        'default'           => '',
        'sanitize_callback' => 'esc_attr',
    )
);
$wp_customize->add_control(
    new Botiga_Text_Control(
        $wp_customize,
        'custom_sidebars_learn_more',
        array(
            'description'       => esc_html__( 'Learn more about this feature in our documentation by clicking on the below link.', 'botiga-pro' ),
            'link_title'        => esc_html__( 'Learn more', 'botiga-pro' ),
            'link'              => 'https://docs.athemes.com/article/pro-custom-sidebars/',
            'check_white_label' => true,
            'section'           => 'botiga_section_sidebar',
            'priority'          => 10
        )
    )
);
