<?php
/**
 * Botiga Pro License
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
} 

/**
 * License activate/deactivate form.
 */
function botiga_pro_license_form() {

	// sanitize data
	$error      = false;
	$license    = ( isset( $_POST['botiga_pro_license_key'] ) ) ? trim( sanitize_text_field( wp_unslash( $_POST['botiga_pro_license_key'] ) ) ) : '';
	$activate   = ( isset( $_POST['botiga_pro_license_activate'] ) ) ? sanitize_text_field( wp_unslash( $_POST['botiga_pro_license_activate'] ) ) : '';
	$deactivate = ( isset( $_POST['botiga_pro_license_deactivate'] ) ) ? sanitize_text_field( wp_unslash( $_POST['botiga_pro_license_deactivate'] ) ) : '';

	if ( $license && check_admin_referer( 'botiga_pro_nonce', 'botiga_pro_nonce' ) ) {

		// activate theme
		if ( $activate ) {

			// data to send in our API request
			$api_params = array(
				'edd_action'=> 'activate_license',
				'license' 	=> $license,
				'item_name' => urlencode( ATHEMES_PLUGIN_NAME ), // the name of our product in EDD
				'url'       => home_url()
			);

			// Call the custom API.
			$response = wp_remote_post( ATHEMES_STORE_URL, array( 'timeout' => 15, 'sslverify' => false, 'body' => $api_params ) );

			// make sure the response came back okay
			if ( ! is_wp_error( $response ) ) {

				// decode the license data
				$license_data = json_decode( wp_remote_retrieve_body( $response ) );

				if ( ! empty( $license_data ) ) {

					// save option with license item name for "Botiga Pro" product
					update_option( 'botiga_pro_license_item_name', 'Botiga Pro' );

					// If is invalid, check again for "Botiga Pro Lifetime" product
					if ( $license_data->license === 'invalid' ) {

						$api_params = array(
							'edd_action'=> 'activate_license',
							'license' 	=> $license,
							'item_name' => urlencode( 'Botiga Pro Lifetime' ), // the name of our product in EDD
							'url'       => home_url()
						);

						$response = wp_remote_post( ATHEMES_STORE_URL, array( 'timeout' => 15, 'sslverify' => false, 'body' => $api_params ) );

						if ( ! is_wp_error( $response ) ) {

							$license_data = json_decode( wp_remote_retrieve_body( $response ) );

							// save option with license item name for "Botiga Pro Lifetime" product
							update_option( 'botiga_pro_license_item_name', 'Botiga Pro Lifetime' );

						}

					}

					if ( ! empty( $license_data ) ) {

						if ( $license_data->license === 'valid' ) {
							update_option( 'botiga_pro_license_key', $license );
							update_option( 'botiga_pro_license_status', $license_data->license );
						} else {
							delete_option( 'botiga_pro_license_key' );
							delete_option( 'botiga_pro_license_status' );
							$error = true;
						}

					}

				}

			}

		}

		// deactivate theme
		if ( $deactivate ) {

			// data to send in our API request
			$api_params = array(
				'edd_action'=> 'deactivate_license',
				'license' 	=> $license,
				'item_name' => urlencode( ATHEMES_PLUGIN_NAME ), // the name of our product in EDD
				'url'       => home_url()
			);

			// Call the custom API.
			$response = wp_remote_post( ATHEMES_STORE_URL, array( 'timeout' => 15, 'sslverify' => false, 'body' => $api_params ) );

			// make sure the response came back okay
			if ( ! is_wp_error( $response ) ) {

				// decode the license data
				$license_data = json_decode( wp_remote_retrieve_body( $response ) );

				if ( ! empty( $license_data ) ) {

					// If is invalid, check again for "Botiga Pro Lifetime" product
					if ( $license_data->license === 'failed' ) {

						$api_params = array(
							'edd_action'=> 'deactivate_license',
							'license' 	=> $license,
							'item_name' => urlencode( 'Botiga Pro Lifetime' ), // the name of our product in EDD
							'url'       => home_url()
						);

						$response = wp_remote_post( ATHEMES_STORE_URL, array( 'timeout' => 15, 'sslverify' => false, 'body' => $api_params ) );

						if ( ! is_wp_error( $response ) ) {
							$license_data = json_decode( wp_remote_retrieve_body( $response ) );
						}

					}

					if ( ! empty( $license_data ) && $license_data->license === 'deactivated' || $license_data->license === 'failed' ) {
						delete_option( 'botiga_pro_license_key' );
						delete_option( 'botiga_pro_license_status' );
					}

				}

			}

		}

	}

	$license = get_option( 'botiga_pro_license_key' );
	$status  = get_option( 'botiga_pro_license_status' );

	if ( ( ( $activate || $deactivate ) && ! $license ) || ( $license && $status !== 'valid' ) ) {
		$error = true;
	}

?>
	<div class="botiga-dashboard-box botiga-dashboard-settings-box">
		<div class="botiga-dashboard-settings-row">
			<div class="botiga-dashboard-settings-column-left">
				<div class="botiga-dashboard-box-title">
					<?php if ( $status === 'valid' ) : ?>
						<i class="dashicons dashicons-unlock"></i>
					<?php else : ?>
						<i class="dashicons dashicons-lock"></i>
					<?php endif; ?>
					<?php esc_html_e( 'Botiga Pro License', 'botiga-pro' ); ?>
				</div>
				<div class="botiga-dashboard-box-content"><?php esc_html_e( 'Activate Botiga Pro to get professional support and automatic updates from your WordPress Dashboard.', 'botiga-pro' ); ?></div>
				<div class="botiga-dashboard-license-form">
					<form action="" method="post" autocomplete="off">
						<i class="dashicons dashicons-admin-network botiga-license-key-icon"></i>
						<?php wp_nonce_field( 'botiga_pro_nonce', 'botiga_pro_nonce' ); ?>
						<?php if ( $status === 'valid' ) : ?>
							<input type="text" name="botiga_pro_license_key" value="<?php echo esc_attr( $license ); ?>" readonly />
							<input type="hidden" name="botiga_pro_license_deactivate" value="deactivate" />
							<button type="submit" name="botiga_pro_license_submit" class="button button-warning botiga-license-button" data-type="deactivate"><?php esc_html_e( 'Deactivate', 'botiga-pro' ); ?></button>
						<?php else : ?>
							<input type="text" name="botiga_pro_license_key" value="<?php echo esc_attr( $license ); ?>" placeholder="<?php esc_html_e( 'Enter your license key here', 'botiga-pro' ); ?>" />
							<input type="hidden" name="botiga_pro_license_activate" value="activate" />
							<button type="submit" name="botiga_pro_license_submit" class="button botiga-license-button" data-type="activate"><?php esc_html_e( 'Activate', 'botiga-pro' ); ?></button>
						<?php endif; ?>
					</form>
				</div>

				<?php if ( $status === 'valid' ) : ?>
					<div class="botiga-dashboard-license-success"><strong><?php esc_html_e( 'License Status:', 'botiga-pro' ); ?></strong><span><?php esc_html_e( 'Active', 'botiga-pro' ); ?></span></div>
				<?php endif; ?>

				<?php if ( $error ) : ?>
					<div class="botiga-dashboard-license-error"><?php esc_html_e( 'Looks like you entered an invalid license key, please check if you entered the correct key and try again.', 'botiga-pro' ); ?></div>
				<?php endif; ?>
			</div>
		</div>
	</div>
	<?php
}
add_action( 'botiga_pro_license_form', 'botiga_pro_license_form' );

/**
 * Admin license notice.
 */
function botiga_pro_license_admin_notice() {

	global $hook_suffix;

	$license = get_option( 'botiga_pro_license_key' );

	if ( $hook_suffix !== 'appearance_page_botiga-dashboard' && ! $license ) {
		echo '<div class="updated">';
		echo '<p>Please activate your license key for Botiga Pro to get the latest plugin updates automatically. You can get your key from your <a href="https://athemes.com/your-account/" target="_blank">aThemes account</a> and activate it <a href="' . esc_url( add_query_arg( array( 'page' => 'botiga-dashboard', 'section' => 'settings', 'tab' => 'general' ), admin_url( 'themes.php' ) ) ) . '">here</a></p>';
		echo '</div>';
	}

}
add_action( 'admin_notices', 'botiga_pro_license_admin_notice' );
