<?php
/**
 * Reading Progress
 * 
 * @package Botiga_Pro
 */

/**
 * Enqueue CSS and JS
 */
function botiga_reading_progress_enqueue_scripts() {

    if( ! is_singular( 'post' ) ) {
        return;
    }

    $single_post_reading_progress = get_theme_mod( 'single_post_reading_progress', 0 );
    if( ! $single_post_reading_progress ) {
        return;
    } 

    wp_enqueue_script( 'botiga-reading-progress', BOTIGA_PRO_URI . 'assets/js/botiga-reading-progress.min.js', array(), BOTIGA_PRO_VERSION, true );
}
add_action( 'wp_enqueue_scripts', 'botiga_reading_progress_enqueue_scripts', 10 );

/**
 * Add body class
 */
function botiga_reading_progress_body_class( $classes ) {
    $classes[] = 'hide-reading-progress';

    return $classes;
}
add_filter( 'body_class', 'botiga_reading_progress_body_class' );

/**
 * Reading Progress Position
 */
function botiga_reading_progress_position() {

    if( ! is_singular( 'post' ) ) {
        return;
    }

    $single_post_reading_progress_position = get_theme_mod( 'single_post_reading_progress_position', 'top' );
    $header_layout_desktop                 = get_theme_mod( 'header_layout_desktop', 'header_layout_1' );

    if( 'top' === $single_post_reading_progress_position ) {

        if ( Botiga_Modules::is_module_active( 'hf-builder' ) ) {
            add_action( 'botiga_before_bhfb_header_output_close_desktop', 'botiga_reading_progress' );
            add_action( 'botiga_before_bhfb_header_output_close_mobile', 'botiga_reading_progress' );

            return;
        }

        if( in_array( $header_layout_desktop, array( 'header_layout_3', 'header_layout_4', 'header_layout_5' ) ) ) {
            add_action( 'botiga_before_bottom_header_row_close', 'botiga_reading_progress' );
        } else {
            add_action( 'botiga_before_header_close', 'botiga_reading_progress' );
        }

        add_action( 'botiga_before_mobile_header_close', 'botiga_reading_progress' );
    } else {
        add_action( 'wp_footer', 'botiga_reading_progress' );
    }

}
add_action( 'wp', 'botiga_reading_progress_position' );

/**
 * Reading Progress HTML output
 */
function botiga_reading_progress() {

    if( ! is_singular( 'post' ) ) {
        return;
    }

    $single_post_reading_progress = get_theme_mod( 'single_post_reading_progress', 0 );
    if( ! $single_post_reading_progress ) {
        return;
    } 
    
    $single_post_reading_progress_position = get_theme_mod( 'single_post_reading_progress_position', 'top' );
    $single_post_reading_progress_comments = get_theme_mod( 'single_post_reading_progress_comments', 0 ); ?>

    <div class="botiga-reading-progress botiga-reading-progress-<?php echo esc_attr( $single_post_reading_progress_position ); ?>" data-inc-comments="<?php echo esc_attr( $single_post_reading_progress_comments ); ?>">
        <div class="botiga-reading-progress__bar"></div>
    </div>

    <?php
}
