<?php
/**
 * Header Image
 * Extend customizer 'Header Image' option with new functionalities
 * 
 * @package Botiga_Pro
 */

/**
 * Extend post/page level metabox with header image options
 * 
 */
if ( class_exists( 'Botiga_Metabox' ) ) {

	class Botiga_Header_Image_Metabox_Options extends Botiga_Metabox {

		public function __construct() {
            if( ! is_admin() ) {
                return;
            }

			add_action( 'botiga_metabox_options', array( $this, 'add_header_image_metabox_options' ) );
		}

		public function add_header_image_metabox_options() {

            // Display the options only if the customizer header image is in use
            if( ! get_header_image() ) {
                return;
            }

			$this->add_field( '_botiga_header_image_id', array(
				'section' => 'general',
				'type'    => 'media',
				'title'   => esc_html__( 'Header Image', 'botiga-pro' ),
                'desc'    => esc_html__( 'Replaces the customizer header image with this new image.', 'botiga-pro' )
			) );

		}
	}

	new Botiga_Header_Image_Metabox_Options();
}

/**
 * Header Image Output
 * 
 */
function botiga_set_header_image_from_post_metabox( $image_tag ) {
    if( is_singular() ) {
        $header_image_id = get_post_meta( get_the_ID(), '_botiga_header_image_id', true );
        if( $header_image_id ) {
            $header_image = wp_get_attachment_image( $header_image_id, 'full' );
            if( $header_image ) {
                $image_tag = $header_image;
            }
        }
    }

    return $image_tag;
}
add_filter( 'botiga_header_image_tag', 'botiga_set_header_image_from_post_metabox' );