<?php
/**
 * Blog Archive Pagination
 * 
 * @package Botiga_Pro
 */

/**
 * Enqueue CSS and JS
 */
function botiga_blog_archive_pagination_enqueue_scripts() {
    if( ! botiga_is_blog_archive_pagination_needed() ) {
        return false;
    }

    wp_enqueue_script( 'botiga-pagination', BOTIGA_PRO_URI . 'assets/js/botiga-pagination.min.js', array(), BOTIGA_PRO_VERSION, true );
    $inline_script = '
        botiga.pagination.defaults = {
            button: document.querySelector( \'.botiga-pagination-button\' ),
            pagination: document.querySelector( \'.navigation.pagination\' ),
            next: document.querySelector( \'.navigation.pagination .next\' ),
            itemsWrapper: document.querySelector( \'.site-main .posts-archive > .row\' ),
            itemsTag: \'article\',
            items: \'.site-main .posts-archive .post, .site-main .posts-archive .page, .site-main .posts-archive .product\',
            currentPage: 1,
            totalPages: document.querySelector( \'.botiga-pagination-button\' ) !== null ? parseInt( document.querySelector( \'.botiga-pagination-button\' ).getAttribute( \'data-total-pages\' ) ) : 0,
            infiniteScroll: document.querySelector( \'.botiga-pagination-button\' ) !== null && document.querySelector( \'.botiga-pagination-button\' ).getAttribute( \'data-pagination-type\' ) === \'infinite-scroll\' ? true : false,
            eventPrefix: \'botiga.blog\',
            triggerOffset: 200
        }
    ';
    wp_add_inline_script( 'botiga-pagination', $inline_script );
}
add_action( 'wp_enqueue_scripts', 'botiga_blog_archive_pagination_enqueue_scripts', 10 );

/**
 * Identify the type of navigation with a body class
 */
function botiga_blog_archive_pagination_active_body_class( $classes ) {
    if( ! botiga_is_blog_archive_pagination_needed() ) {
        return $classes;
    }

    $classes[] = 'botiga-pagination-load-more';

    return $classes;
}
add_filter( 'body_class', 'botiga_blog_archive_pagination_active_body_class' );

/**
 * Insert button HTML through hook
 */
function botiga_blog_archive_pagination_hooks() {
    if( ! botiga_is_blog_archive_pagination_needed() ) {
        return false;
    }

    // Remove default woo pagination
    add_action( 'botiga_after_the_posts_pagination', 'botiga_blog_archive_pagination_load_more_button' );

}
add_action( 'wp', 'botiga_blog_archive_pagination_hooks' );

/**
 * Pagination Button
 */
function botiga_blog_archive_pagination_load_more_button() { 
    global $wp_query;

    $total_pages                  = $wp_query->max_num_pages;
    $blog_archive_pagination_type = get_theme_mod( 'blog_archive_pagination_type', 'default' ); 
    
    if( $total_pages <= 1 ) {
        return;
    }

    ?>

    <div class="botiga-pagination-wrapper">
        <a href="javascript:void(0);" class="botiga-pagination-button<?php echo ( $blog_archive_pagination_type === 'infinite-scroll' ) ? ' loading-anim' : ' button'; ?>" role="button" data-current-page="1" data-total-pages="<?php echo esc_attr( $total_pages ); ?>" data-pagination-type="<?php echo esc_attr( $blog_archive_pagination_type ); ?>">
            <span class="botiga-pagination-button__label">
                <?php echo esc_html__( 'Load More', 'botiga-pro' ); ?>
            </span>
            <span class="botiga-pagination-button__loader">
                <svg xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 512 512" aria-hidden="true" focusable="false">
                    <path fill="#FFF" d="M288 39.056v16.659c0 10.804 7.281 20.159 17.686 23.066C383.204 100.434 440 171.518 440 256c0 101.689-82.295 184-184 184-101.689 0-184-82.295-184-184 0-84.47 56.786-155.564 134.312-177.219C216.719 75.874 224 66.517 224 55.712V39.064c0-15.709-14.834-27.153-30.046-23.234C86.603 43.482 7.394 141.206 8.003 257.332c.72 137.052 111.477 246.956 248.531 246.667C393.255 503.711 504 392.788 504 256c0-115.633-79.14-212.779-186.211-240.236C302.678 11.889 288 23.456 288 39.056z" />
                </svg>
            </span>
        </a>
    </div>
    <?php
}

/**
 * Check if should run the pagination code
 */
function botiga_is_blog_archive_pagination_needed() {
    if( class_exists( 'Woocommerce' ) && is_shop() ) {
        return false;
    }

    if( ! is_home() && ! is_category() && ! is_tag() && ! is_search() ) {
        return false;
    }

    $blog_archive_pagination_type = get_theme_mod( 'blog_archive_pagination_type', 'default' );
    if( 'default' === $blog_archive_pagination_type ) {
        return false;
    }

    return true;
}