<?php
/**
 * WooCommerce Single Customizer options
 *
 * @package Botiga_Pro
 */
/**
 * Extend single product elements with new options
 * 
 */
function botiga_pro_single_product_elements( $elements ) {
    $elements['botiga_single_product_html']              = esc_html__( 'HTML', 'botiga-pro' );
    $elements['botiga_single_product_shortcode']         = esc_html__( 'Shortcode', 'botiga-pro' );
    $elements['botiga_single_product_reasons_to_buy']    = esc_html__( 'Reasons To Buy', 'botiga-pro' );
    $elements['botiga_single_product_trust_badge_image'] = esc_html__( 'Trust Badge', 'botiga-pro' );
    $elements['botiga_single_product_brand_image']       = esc_html__( 'Brand Image', 'botiga-pro' );

    return $elements;
}
add_filter( 'botiga_single_product_elements', 'botiga_pro_single_product_elements' );

/**
 * Add new customizer options
 * 
 */
function botiga_pro_woocommerce_single( $wp_customize ) {

    /**
     * Tabs control
     */
    $controls_general     = json_decode( $wp_customize->get_control( 'botiga_single_product_tabs' )->controls_general );
    $new_controls_general = array(
        '#customize-control-single_product_sidebar_divider_1',
        '#customize-control-single_product_sidebar_divider_2',
        '#customize-control-single_product_sidebar',
        '#customize-control-shop_single_sidebar', '#customize-control-single_product_navigation',
        '#customize-control-botiga_single_product_html_content',
        '#customize-control-botiga_single_product_shortcode_content',
        '#customize-control-botiga_single_product_reasons_title',
        '#customize-control-botiga_single_product_reasons',
        '#customize-control-botiga_single_product_trust_badge_image',
        '#customize-control-shop_single_related_products_slider',
        '#customize-control-shop_single_related_products_slider_nav',
        '#customize-control-shop_single_related_products_number',
        '#customize-control-shop_single_related_products_columns_number',
        '#customize-control-shop_single_upsell_products_slider',
        '#customize-control-shop_single_upsell_products_slider_nav',
        '#customize-control-shop_single_upsell_products_number',
        '#customize-control-shop_single_upsell_products_columns_number',
        '#customize-control-shop_single_recently_viewed_products_slider',
        '#customize-control-shop_single_recently_viewed_products_slider_nav',
        '#customize-control-shop_single_recently_viewed_products_number',
        '#customize-control-shop_single_recently_viewed_products_columns_number',
        '#customize-control-accordion_single_product_layout',
        '#customize-control-accordion_single_product_tabs',
        '#customize-control-single_product_tabs_position',
        '#customize-control-single_product_tabs_layout',
        '#customize-control-single_product_tabs_alignment',
        '#customize-control-single_product_tabs_accordion_title',
        '#customize-control-single_product_tabs_accordion_one_at_time',
    );
    $wp_customize->get_control( 'botiga_single_product_tabs' )->controls_general = json_encode( array_merge( $controls_general, $new_controls_general ) );

    $controls_design     = json_decode( $wp_customize->get_control( 'botiga_single_product_tabs' )->controls_design );
    $new_controls_design = array(
        '#customize-control-accordion_single_product_styling_layout',
        '#customize-control-accordion_single_product_styling_tabs',
        '#customize-control-single_product_tabs_state_title',
        '#customize-control-single_product_tabs_border_color',
        '#customize-control-single_product_tabs_background_color',
        '#customize-control-single_product_tabs_text_color',
        '#customize-control-single_product_tabs_state_title2',
        '#customize-control-single_product_tabs_border_color_active',
        '#customize-control-single_product_tabs_background_color_active',
        '#customize-control-single_product_tabs_text_color_active',
        '#customize-control-single_product_tabs_remaining_borders',
        '#customize-control-single_product_gallery_styles_divider1',
        '#customize-control-single_product_gallery_styles_title1',
        '#customize-control-single_product_gallery_styles_background_color',
        '#customize-control-single_product_gallery_styles_padding_top_bottom',
        '#customize-control-single_product_upsell_title',
        '#customize-control-single_product_upsell_section_background_color',
        '#customize-control-single_product_related_section_background_color',
        '#customize-control-single_product_recently_section_background_color'
    );
    $wp_customize->get_control( 'botiga_single_product_tabs' )->controls_design = json_encode( array_merge( $controls_design, $new_controls_design ) );

    /**
     * General
     */
    $wp_customize->add_setting( 'accordion_single_product_layout', 
        array(
            'sanitize_callback' => 'esc_attr'
        )
    );
    $wp_customize->add_control(
        new Botiga_Accordion_Control(
            $wp_customize,
            'accordion_single_product_layout',
            array(
                'label'         => esc_html__( 'Layout', 'botiga-pro' ),
                'section'       => 'botiga_section_single_product',
                'until'         => 'shop_single_related_products_columns_number',
                'priority'      => 11
            )
        )
    );

    //Gallery Styles
    $wp_customize->get_control( 'single_product_gallery' )->choices = array(
        'gallery-default' => array(
            'label' => esc_html__( 'Layout 1', 'botiga-pro' ),
            'url'   => '%s/assets/img/sg1.svg'
        ),
        'gallery-single' => array(
            'label' => esc_html__( 'Layout 2', 'botiga-pro' ),
            'url'   => '%s/assets/img/sg2.svg'
        ),	
        'gallery-vertical' => array(
            'label' => esc_html__( 'Layout 3', 'botiga-pro' ),
            'url'   => '%s/assets/img/sg3.svg'
        ),
        'gallery-grid' => array(
            'label' => esc_html__( 'Layout 4', 'botiga-pro' ),
            'url'   => '%s/assets/img/sg4.svg'
        ),
        'gallery-scrolling' => array(
            'label' => esc_html__( 'Layout 5', 'botiga-pro' ),
            'url'   => '%s/assets/img/sg5.svg'
        ),
        'gallery-showcase' => array(
            'label' => esc_html__( 'Layout 6', 'botiga-pro' ),
            'url'   => '%s/assets/img/sg6.svg'
        ),
        'gallery-full-width' => array(
            'label' => esc_html__( 'Layout 7', 'botiga-pro' ),
            'url'   => '%s/assets/img/sg7.svg'
        ),
    );

    $wp_customize->get_control( 'single_gallery_slider' )->active_callback = 'botiga_callback_single_product_gallery_layout';
    $wp_customize->get_control( 'single_zoom_effects' )->active_callback = 'botiga_callback_single_product_gallery_layout';

    // Product Navigation
    $wp_customize->add_setting(
        'single_product_navigation',
        array(
            'default'           => 0,
            'sanitize_callback' => 'botiga_sanitize_checkbox',
        )
    );
    $wp_customize->add_control(
        new Botiga_Toggle_Control(
            $wp_customize,
            'single_product_navigation',
            array(
                'label'    => esc_html__( 'Product Navigation', 'botiga-pro' ),
                'section'  => 'botiga_section_single_product',
                'priority' => 50
            )
        )
    );

    // Sidebar
    $wp_customize->add_setting( 'single_product_sidebar_divider_1',
        array(
            'sanitize_callback' => 'esc_attr'
        )
    );

    $wp_customize->add_control( new Botiga_Divider_Control( $wp_customize, 'single_product_sidebar_divider_1',
            array(
                'section'  => 'botiga_section_single_product',
                'priority' => 60
            )
        )
    );

    $wp_customize->add_setting(
        'single_product_sidebar',
        array(
            'default'           => 'no-sidebar',
            'sanitize_callback' => 'sanitize_key',
        )
    );
    $wp_customize->add_control(
        new Botiga_Radio_Images(
            $wp_customize,
            'single_product_sidebar',
            array(
                'label'   => esc_html__( 'Sidebar Layout', 'botiga-pro' ),
                'section' => 'botiga_section_single_product',
                'cols'    => 3,
                'choices' => array(
                    'no-sidebar'    => array(
                        'label'     => esc_html__( 'No Sidebar', 'botiga-pro' ),
                        'url'       => '%s/assets/img/meta-sidebar-none.svg'
                    ),
                    'sidebar-left'  => array(
                        'label'     => esc_html__( 'Left', 'botiga-pro' ),
                        'url'       => '%s/assets/img/meta-sidebar-left.svg'
                    ),
                    'sidebar-right' => array(
                        'label'     => esc_html__( 'Right', 'botiga-pro' ),
                        'url'       => '%s/assets/img/meta-sidebar-right.svg'
                    ),  
                ),
                'priority' => 60
            )
        )
    );
    
    // Shop Single Sidebar
    $wp_customize->add_setting( 
        'shop_single_sidebar', 
        array(
            'default'           => '',
            'sanitize_callback' => 'botiga_sanitize_select',
        ) 
    );
    $wp_customize->add_control( 
        'shop_single_sidebar', 
        array(
            'type'            => 'select',
            'section'         => 'botiga_section_single_product',
            'label'           => esc_html__( 'Sidebar', 'botiga-pro' ),
            'choices'         => botiga_pro_get_registered_sidebars(),
            'active_callback' => 'botiga_callback_shop_single_sidebar',
            'priority'        => 60,
        ) 
    );

    $wp_customize->add_setting( 'single_product_sidebar_divider_2',
        array(
            'sanitize_callback' => 'esc_attr'
        )
    );

    $wp_customize->add_control( new Botiga_Divider_Control( $wp_customize, 'single_product_sidebar_divider_2',
            array(
                'section'  => 'botiga_section_single_product',
                'priority' => 60
            )
        )
    );

    // Elements - HTML output content
    $wp_customize->add_setting(
        'botiga_single_product_html_content',
        array(
            'sanitize_callback' => 'botiga_sanitize_text',
            'default'           => '',
        )       
    );
    $wp_customize->add_control( 
        'botiga_single_product_html_content', 
        array(
            'label'           => esc_html__( 'HTML Content', 'botiga-pro' ),
            'type'            => 'textarea',
            'section'         => 'botiga_section_single_product',
            'active_callback' => function() { return botiga_callback_single_product_elements( 'botiga_single_product_html' ); },
            'priority'        => 91
        ) 
    );

    // Elements - Shortcode output content
    $wp_customize->add_setting(
        'botiga_single_product_shortcode_content',
        array(
            'sanitize_callback' => 'botiga_sanitize_text',
            'default'           => '',
        )       
    );
    $wp_customize->add_control( 
        'botiga_single_product_shortcode_content', 
        array(
            'label'           => esc_html__( 'Shortcode Tag', 'botiga-pro' ),
            'type'            => 'text',
            'section'         => 'botiga_section_single_product',
            'active_callback' => function() { return botiga_callback_single_product_elements( 'botiga_single_product_shortcode' ); },
            'priority'        => 91
        ) 
    );

    // Elements - Reasons to buy title
    $wp_customize->add_setting(
        'botiga_single_product_reasons_title',
        array(
            'default'           => '',
            'sanitize_callback' => 'botiga_sanitize_text'
        )
    );
    $wp_customize->add_control(
        'botiga_single_product_reasons_title',
        array(
            'label'           => __( 'Title for the reasons to buy list', 'botiga-pro' ),
            'type'            => 'text',
            'section'         => 'botiga_section_single_product',
            'active_callback' => function() { return botiga_callback_single_product_elements( 'botiga_single_product_reasons_to_buy' ); },
            'priority'        => 91
        )
    );

    // Elements - Reasons to buy sortable list
    $wp_customize->add_setting(
        'botiga_single_product_reasons',
        array(
            'default'           => '',
            'sanitize_callback' => 'wp_kses_post'
        )
    );
    $wp_customize->add_control(
        new Botiga_Repeater_Control(
            $wp_customize,
            'botiga_single_product_reasons',
            array(
                'label'           => __( 'Reasons to buy list items', 'botiga-pro' ),
                'regular_field'   => true,
                'section'         => 'botiga_section_single_product',
                'active_callback' => function() { return botiga_callback_single_product_elements( 'botiga_single_product_reasons_to_buy' ); },
                'priority'        => 91
            )
        )
    );

    // Elements - Trust Badge Image
    $wp_customize->add_setting(
        'botiga_single_product_trust_badge_image',
        array(
            'default'           => '',
            'sanitize_callback' => 'esc_url_raw'
        )
    );
    $wp_customize->add_control(
        new WP_Customize_Image_Control(
            $wp_customize,
            'botiga_single_product_trust_badge_image',
            array(
                'label'          => __( 'Upload your trust badge image', 'botiga-pro' ),
                'section'        => 'botiga_section_single_product',
                'active_callback' => function() { return botiga_callback_single_product_elements( 'botiga_single_product_trust_badge_image' ); },
                'priority'       => 91
            )
        )
    );
    
    // Related Producs as Slider
    $wp_customize->add_setting(
        'shop_single_related_products_slider',
        array(
            'default'           => 0,
            'sanitize_callback' => 'botiga_sanitize_checkbox',
        )
    );
    $wp_customize->add_control(
        new Botiga_Toggle_Control(
            $wp_customize,
            'shop_single_related_products_slider',
            array(
                'label'         	=> esc_html__( 'Related products slider', 'botiga-pro' ),
                'section'       	=> 'botiga_section_single_product',
                'active_callback'   => 'botiga_callback_shop_single_show_related_products',
                'priority' 			=> 111
            )
        )
    );

    // Related products slider nav
    $wp_customize->add_setting( 
        'shop_single_related_products_slider_nav',
        array(
            'default' 			=> 'always-show',
            'sanitize_callback' => 'botiga_sanitize_text'
        )
    );
    $wp_customize->add_control( 
        new Botiga_Radio_Buttons( 
            $wp_customize, 
            'shop_single_related_products_slider_nav',
            array(
                'label' 	      => esc_html__( 'Related products slider navigation', 'botiga-pro' ),
                'section' 	      => 'botiga_section_single_product',
                'active_callback' => 'botiga_callback_shop_single_related_products_slider_navigation',
                'choices'         => array(
                    'always-show' => esc_html__( 'Always show', 'botiga-pro' ),
                    'hover-show'  => esc_html__( 'Show on hover', 'botiga-pro' ),
                ),
                'priority' 		  => 111
            )
        ) 
    );

    // Related products number
    $wp_customize->add_setting( 
        'shop_single_related_products_number', 
        array(
            'default'   		=> 3,
            'sanitize_callback' => 'absint',
        ) 
    );			
    $wp_customize->add_control( 
        new Botiga_Responsive_Slider( 
            $wp_customize, 
            'shop_single_related_products_number',
            array(
                'label' 		=> esc_html__( 'Number of products', 'botiga-pro' ),
                'section' 		=> 'botiga_section_single_product',
                'active_callback'   => 'botiga_callback_shop_single_show_related_products',
                'is_responsive'	=> 0,
                'settings' 		=> array (
                    'size_desktop' 		=> 'shop_single_related_products_number',
                ),
                'input_attrs' => array (
                    'min'	=> 1,
                    'max'	=> 25,
                    'step'  => 1,
                    'unit'  => '',
                ),
                'priority'      => 111
            )
        )
    );

    // Related products columns number
    $wp_customize->add_setting( 
        'shop_single_related_products_columns_number', 
        array(
            'default'   		=> 3,
            'sanitize_callback' => 'absint',
        ) 
    );			
    $wp_customize->add_control( 
        new Botiga_Responsive_Slider( 
            $wp_customize, 
            'shop_single_related_products_columns_number',
            array(
                'label' 		=> esc_html__( 'Number of columns', 'botiga-pro' ),
                'section' 		=> 'botiga_section_single_product',
                'active_callback'   => 'botiga_callback_shop_single_show_related_products',
                'is_responsive'	=> 0,
                'settings' 		=> array (
                    'size_desktop' 		=> 'shop_single_related_products_columns_number',
                ),
                'input_attrs' => array (
                    'min'	=> 1,
                    'max'	=> 6,
                    'step'  => 1,
                    'unit'  => '',
                ),
                'priority' 		=> 111
            )
        )
    );

    // Upsell products as Slider
    $wp_customize->add_setting(
        'shop_single_upsell_products_slider',
        array(
            'default'           => 0,
            'sanitize_callback' => 'botiga_sanitize_checkbox',
        )
    );
    $wp_customize->add_control(
        new Botiga_Toggle_Control(
            $wp_customize,
            'shop_single_upsell_products_slider',
            array(
                'label'         	=> esc_html__( 'Upsell products slider', 'botiga-pro' ),
                'section'       	=> 'botiga_section_single_product',
                'active_callback'   => 'botiga_callback_shop_single_show_upsell_products',
                'priority' 			=> 101
            )
        )
    );

    // Upsell products slider nav
    $wp_customize->add_setting( 
        'shop_single_upsell_products_slider_nav',
        array(
            'default' 			=> 'always-show',
            'sanitize_callback' => 'botiga_sanitize_text'
        )
    );
    $wp_customize->add_control( 
        new Botiga_Radio_Buttons( 
            $wp_customize, 
            'shop_single_upsell_products_slider_nav',
            array(
                'label' 	      => esc_html__( 'Upsell products slider navigation', 'botiga-pro' ),
                'section' 	      => 'botiga_section_single_product',
                'active_callback' => 'botiga_callback_shop_single_upsell_products_slider_navigation',
                'choices'         => array(
                    'always-show' => esc_html__( 'Always show', 'botiga-pro' ),
                    'hover-show'  => esc_html__( 'Show on hover', 'botiga-pro' ),
                ),
                'priority' 		  => 101
            )
        ) 
    );

    // Upsell products number
    $wp_customize->add_setting( 
        'shop_single_upsell_products_number', 
        array(
            'default'   		=> 3,
            'sanitize_callback' => 'absint',
        ) 
    );			
    $wp_customize->add_control( 
        new Botiga_Responsive_Slider( 
            $wp_customize, 
            'shop_single_upsell_products_number',
            array(
                'label' 		=> esc_html__( 'Number of products', 'botiga-pro' ),
                'section' 		=> 'botiga_section_single_product',
                'active_callback'   => 'botiga_callback_shop_single_show_upsell_products',
                'is_responsive'	=> 0,
                'settings' 		=> array (
                    'size_desktop' 		=> 'shop_single_upsell_products_number',
                ),
                'input_attrs' => array (
                    'min'	=> 1,
                    'max'	=> 25,
                    'step'  => 1,
                    'unit'  => '',
                ),
                'priority'      => 101
            )
        )
    );

    // Upsell products columns number
    $wp_customize->add_setting( 
        'shop_single_upsell_products_columns_number', 
        array(
            'default'   		=> 3,
            'sanitize_callback' => 'absint',
        ) 
    );			
    $wp_customize->add_control( 
        new Botiga_Responsive_Slider( 
            $wp_customize, 
            'shop_single_upsell_products_columns_number',
            array(
                'label' 		=> esc_html__( 'Number of columns', 'botiga-pro' ),
                'section' 		=> 'botiga_section_single_product',
                'active_callback'   => 'botiga_callback_shop_single_show_upsell_products',
                'is_responsive'	=> 0,
                'settings' 		=> array (
                    'size_desktop' 		=> 'shop_single_upsell_products_columns_number',
                ),
                'input_attrs' => array (
                    'min'	=> 1,
                    'max'	=> 6,
                    'step'  => 1,
                    'unit'  => '',
                ),
                'priority' 		=> 101
            )
        )
    );

    // Recently Viewed Producs as Slider
    $wp_customize->add_setting(
        'shop_single_recently_viewed_products_slider',
        array(
            'default'           => 0,
            'sanitize_callback' => 'botiga_sanitize_checkbox',
        )
    );
    $wp_customize->add_control(
        new Botiga_Toggle_Control(
            $wp_customize,
            'shop_single_recently_viewed_products_slider',
            array(
                'label'         	=> esc_html__( 'Recently viewed products slider', 'botiga-pro' ),
                'section'       	=> 'botiga_section_single_product',
                'active_callback'   => 'botiga_callback_shop_single_show_recently_viewed_products',
                'priority' 			=> 104
            )
        )
    );

    // Recently Viewed products slider nav
    $wp_customize->add_setting( 
        'shop_single_recently_viewed_products_slider_nav',
        array(
            'default' 			=> 'always-show',
            'sanitize_callback' => 'botiga_sanitize_text'
        )
    );
    $wp_customize->add_control( 
        new Botiga_Radio_Buttons( 
            $wp_customize, 
            'shop_single_recently_viewed_products_slider_nav',
            array(
                'label' 	      => esc_html__( 'Recently viewed products slider navigation', 'botiga-pro' ),
                'section' 	      => 'botiga_section_single_product',
                'active_callback' => 'botiga_callback_shop_single_recently_viewed_products_slider_navigation',
                'choices'         => array(
                    'always-show' => esc_html__( 'Always show', 'botiga-pro' ),
                    'hover-show'  => esc_html__( 'Show on hover', 'botiga-pro' ),
                ),
                'priority' 		  => 104
            )
        ) 
    );

    // Recently viewed products number
    $wp_customize->add_setting( 
        'shop_single_recently_viewed_products_number', 
        array(
            'default'   		=> 3,
            'sanitize_callback' => 'absint',
        ) 
    );			
    $wp_customize->add_control( 
        new Botiga_Responsive_Slider( 
            $wp_customize, 
            'shop_single_recently_viewed_products_number',
            array(
                'label' 		=> esc_html__( 'Number of products', 'botiga-pro' ),
                'section' 		=> 'botiga_section_single_product',
                'active_callback'   => 'botiga_callback_shop_single_show_recently_viewed_products',
                'is_responsive'	=> 0,
                'settings' 		=> array (
                    'size_desktop' 		=> 'shop_single_recently_viewed_products_number',
                ),
                'input_attrs' => array (
                    'min'	=> 1,
                    'max'	=> 25,
                    'step'  => 1,
                    'unit'  => '',
                ),
                'priority'      => 104
            )
        )
    );

    // Recently viewed products columns number
    $wp_customize->add_setting( 
        'shop_single_recently_viewed_products_columns_number', 
        array(
            'default'   		=> 3,
            'sanitize_callback' => 'absint',
        ) 
    );			
    $wp_customize->add_control( 
        new Botiga_Responsive_Slider( 
            $wp_customize, 
            'shop_single_recently_viewed_products_columns_number',
            array(
                'label' 		=> esc_html__( 'Number of columns', 'botiga-pro' ),
                'section' 		=> 'botiga_section_single_product',
                'active_callback'   => 'botiga_callback_shop_single_show_recently_viewed_products',
                'is_responsive'	=> 0,
                'settings' 		=> array (
                    'size_desktop' 		=> 'shop_single_recently_viewed_products_columns_number',
                ),
                'input_attrs' => array (
                    'min'	=> 1,
                    'max'	=> 6,
                    'step'  => 1,
                    'unit'  => '',
                ),
                'priority' 		=> 104
            )
        )
    );

    //Tabs
    $wp_customize->add_setting( 'accordion_single_product_tabs', 
        array(
            'sanitize_callback' => 'esc_attr',
        )
    );
    $wp_customize->add_control(
        new Botiga_Accordion_Control(
            $wp_customize,
            'accordion_single_product_tabs',
            array(
                'label'         => esc_html__( 'Tabs', 'botiga-pro' ),
                'section'       => 'botiga_section_single_product',
                'until'         => 'single_product_tabs_accordion_one_at_time',
                'priority'      => 112
            )
        )
    );

    $wp_customize->add_setting(
        'single_product_tabs_position',
        array(
            'default'           => 'default',
            'sanitize_callback' => 'sanitize_key',
        )
    );
    $wp_customize->add_control(
        new Botiga_Radio_Images(
            $wp_customize,
            'single_product_tabs_position',
            array(
                'label'    	=> esc_html__( 'Position', 'botiga-pro' ),
                'section'  	=> 'botiga_section_single_product',
                'cols'		=> 2,
                'choices'  => array(
                    'default' => array(
                        'label' => esc_html__( 'Default', 'botiga-pro' ),
                        'url'   => '%s/assets/img/tabs-pos1.svg'
                    ),
                    'product-summary' => array(
                        'label' => esc_html__( 'Product Summary', 'botiga-pro' ),
                        'url'   => '%s/assets/img/tabs-pos2.svg'
                    )
                ),
                'priority'	 => 112
            )
        )
    );

    $wp_customize->add_setting(
        'single_product_tabs_layout',
        array(
            'default'           => 'style1',
            'sanitize_callback' => 'sanitize_key',
        )
    );
    $wp_customize->add_control(
        new Botiga_Radio_Images(
            $wp_customize,
            'single_product_tabs_layout',
            array(
                'label'    	=> esc_html__( 'Layout Style', 'botiga-pro' ),
                'section'  	=> 'botiga_section_single_product',
                'cols'		=> 2,
                'choices'  => array(
                    'style1' => array(
                        'label' => esc_html__( 'Style 1', 'botiga-pro' ),
                        'url'   => '%s/assets/img/tabs1.svg'
                    ),
                    'style2' => array(
                        'label' => esc_html__( 'Style 2', 'botiga-pro' ),
                        'url'   => '%s/assets/img/tabs2.svg'
                    ),
                    'style3' => array(
                        'label' => esc_html__( 'Style 3', 'botiga-pro' ),
                        'url'   => '%s/assets/img/tabs3.svg'
                    ),
                    'style4' => array(
                        'label' => esc_html__( 'Style 4', 'botiga-pro' ),
                        'url'   => '%s/assets/img/tabs4.svg'
                    ),
                    'style5' => array(
                        'label' => esc_html__( 'Style 5', 'botiga-pro' ),
                        'url'   => '%s/assets/img/tabs5.svg'
                    ),
                    'style6' => array(
                        'label' => esc_html__( 'Style 6', 'botiga-pro' ),
                        'url'   => '%s/assets/img/tabs6.svg'
                    ),
                ),
                'priority'	 => 112
            )
        )
    );

    $wp_customize->add_setting( 
        'single_product_tabs_alignment',
        array(
            'default' 			=> 'left',
            'sanitize_callback' => 'botiga_sanitize_text',
            'transport'         => 'postMessage'
        )
    );
    $wp_customize->add_control( 
        new Botiga_Radio_Buttons( 
            $wp_customize, 
            'single_product_tabs_alignment',
            array(
                'label' 	      => esc_html__( 'Alignment', 'botiga-pro' ),
                'section' 	      => 'botiga_section_single_product',
                'choices'         => array(
                    'left'   => esc_html__( 'Left', 'botiga-pro' ),
                    'center' => esc_html__( 'Center', 'botiga-pro' ),
                    'right'  => esc_html__( 'Right', 'botiga-pro' )
                ),
                'active_callback' => 'botiga_single_product_tabs_alignment',
                'priority'        => 112
            )
        ) 
    );

    $wp_customize->add_setting( 
        'single_product_tabs_accordion_title',
        array(
            'default' 			=> '',
            'sanitize_callback' => 'esc_attr'
        )
    );
    $wp_customize->add_control( 
        new Botiga_Text_Control( 
            $wp_customize, 
            'single_product_tabs_accordion_title',
            array(
                'label'			  => esc_html__( 'Accordion Options', 'botiga-pro' ),
                'section' 		  => 'botiga_section_single_product',
                'active_callback' => 'botiga_single_product_tabs_is_accordion_layout',
                'priority'	 	  => 112
            )
        )
    );

    $wp_customize->add_setting(
        'single_product_tabs_accordion_one_at_time',
        array(
            'default'           => 1,
            'sanitize_callback' => 'botiga_sanitize_checkbox',
        )
    );
    $wp_customize->add_control(
        new Botiga_Toggle_Control(
            $wp_customize,
            'single_product_tabs_accordion_one_at_time',
            array(
                'label'           => esc_html__( 'Open One At a Time', 'botiga-pro' ),
                'section'         => 'botiga_section_single_product',
                'active_callback' => 'botiga_single_product_tabs_is_accordion_layout',
                'priority'	      => 112
            )
        )
    );

    /**
     * Styling
     */
    $wp_customize->add_setting( 'accordion_single_product_styling_layout', 
        array(
            'sanitize_callback' => 'esc_attr'
        )
    );
    $wp_customize->add_control(
        new Botiga_Accordion_Control(
            $wp_customize,
            'accordion_single_product_styling_layout',
            array(
                'label'         => esc_html__( 'Layout', 'botiga-pro' ),
                'section'       => 'botiga_section_single_product',
                'until'         => 'single_product_recently_section_background_color',
                'priority'      => 140
            )
        )
    );

    // Gallery Styles
    $wp_customize->add_setting( 
        'single_product_gallery_styles_divider1',
        array(
            'sanitize_callback' => 'esc_attr'
        )
    );
    $wp_customize->add_control( 
        new Botiga_Divider_Control( 
            $wp_customize, 
            'single_product_gallery_styles_divider1',
            array(
                'section' 		  => 'botiga_section_single_product',
                'active_callback' => 'botiga_callback_single_product_gallery_image_layout',
                'priority'	 	  => 150
            )
        )
    );

    $wp_customize->add_setting( 
        'single_product_gallery_styles_title1',
        array(
            'default' 			=> '',
            'sanitize_callback' => 'esc_attr'
        )
    );
    $wp_customize->add_control( 
        new Botiga_Text_Control( 
            $wp_customize, 
            'single_product_gallery_styles_title1',
            array(
                'label'			  => esc_html__( 'Product Image', 'botiga-pro' ),
                'section' 		  => 'botiga_section_single_product',
                'active_callback' => 'botiga_callback_single_product_gallery_image_layout',
                'priority'	 	  => 150
            )
        )
    );

    $wp_customize->add_setting(
        'single_product_gallery_styles_background_color',
        array(
            'default'           => '#f5f5f5',
            'sanitize_callback' => 'botiga_sanitize_hex_rgba',
            'transport'         => 'postMessage'
        )
    );
    $wp_customize->add_control(
        new Botiga_Alpha_Color(
            $wp_customize,
            'single_product_gallery_styles_background_color',
            array(
                'label'         	=> esc_html__( 'Background Color', 'botiga-pro' ),
                'section'       	=> 'botiga_section_single_product',
                'active_callback'   => 'botiga_callback_single_product_gallery_image_layout',
                'priority'          => 150
            )
        )
    );

    $wp_customize->add_setting( 
        'single_product_gallery_styles_padding_top_bottom', 
        array(
            'default'   		=> 80,
            'transport'			=> 'postMessage',
            'sanitize_callback' => 'botiga_sanitize_text',
        ) 
    );			
    $wp_customize->add_control( 
        new Botiga_Responsive_Slider( 
            $wp_customize, 
            'single_product_gallery_styles_padding_top_bottom',
            array(
                'label' 		  => esc_html__( 'Spacing Top/Bottom', 'botiga-pro' ),
                'section' 		  => 'botiga_section_single_product',
                'active_callback' => 'botiga_callback_single_product_gallery_image_layout',
                'is_responsive'   => 0,
                'settings' 		  => array (
                    'size_desktop' 		=> 'single_product_gallery_styles_padding_top_bottom',
                ),
                'input_attrs'     => array (
                    'min'	=> 0,
                    'max'	=> 80,
                    'step'  => 1
                ),
                'priority'        => 150
            )
        ) 
    );

    $wp_customize->add_setting( 'single_product_upsell_title',
      array(
        'default'           => '',
        'sanitize_callback' => 'esc_attr'
      )
    );
    $wp_customize->add_control( new Botiga_Text_Control( $wp_customize, 'single_product_upsell_title',
        array(
          'label'    => esc_html__( 'Upsell and Related', 'botiga-pro' ),
          'section'  => 'botiga_section_single_product',
          'priority' => 150
        )
      )
    );

    // Upsell products section style
    $wp_customize->add_setting(
        'single_product_upsell_section_background_color',
        array(
            'default'           => 'rgba(255,255,255,0)',
            'sanitize_callback' => 'botiga_sanitize_hex_rgba',
            'transport'         => 'postMessage'
        )
    );
    $wp_customize->add_control(
        new Botiga_Alpha_Color(
            $wp_customize,
            'single_product_upsell_section_background_color',
            array(
                'label'         	=> esc_html__( 'Upsell Products Background', 'botiga-pro' ),
                'section'       	=> 'botiga_section_single_product',
                'active_callback'   => 'botiga_callback_single_product_upsell_active',
                'priority'          => 150
            )
        )
    );

    // Related products section style
    $wp_customize->add_setting(
        'single_product_related_section_background_color',
        array(
            'default'           => 'rgba(255,255,255,0)',
            'sanitize_callback' => 'botiga_sanitize_hex_rgba',
            'transport'         => 'postMessage'
        )
    );
    $wp_customize->add_control(
        new Botiga_Alpha_Color(
            $wp_customize,
            'single_product_related_section_background_color',
            array(
                'label'         	=> esc_html__( 'Related Products Background', 'botiga-pro' ),
                'section'       	=> 'botiga_section_single_product',
                'active_callback'   => 'botiga_callback_single_product_related_active',
                'priority'          => 150
            )
        )
    );

    // Recently viewed products section style
    $wp_customize->add_setting(
        'single_product_recently_section_background_color',
        array(
            'default'           => 'rgba(255,255,255,0)',
            'sanitize_callback' => 'botiga_sanitize_hex_rgba',
            'transport'         => 'postMessage'
        )
    );
    $wp_customize->add_control(
        new Botiga_Alpha_Color(
            $wp_customize,
            'single_product_recently_section_background_color',
            array(
                'label'         	=> esc_html__( 'Recently Products Background', 'botiga-pro' ),
                'section'       	=> 'botiga_section_single_product',
                'active_callback'   => 'botiga_callback_single_product_recently_viewed_active',
                'priority'          => 150
            )
        )
    );

    // Tabs
    $wp_customize->add_setting( 'accordion_single_product_styling_tabs', 
        array(
            'sanitize_callback' => 'esc_attr'
        )
    );
    $wp_customize->add_control(
        new Botiga_Accordion_Control(
            $wp_customize,
            'accordion_single_product_styling_tabs',
            array(
                'label'         => esc_html__( 'Tabs', 'botiga-pro' ),
                'section'       => 'botiga_section_single_product',
                'until'         => 'single_product_tabs_remaining_borders',
                'priority'      => 150
            )
        )
    );

    $wp_customize->add_setting( 
        'single_product_tabs_state_title',
        array(
            'default' 			=> '',
            'sanitize_callback' => 'esc_attr'
        )
    );
    $wp_customize->add_control( 
        new Botiga_Text_Control( 
            $wp_customize, 
            'single_product_tabs_state_title',
            array(
                'label'			=> esc_html__( 'Default State', 'botiga-pro' ),
                'section' 		=> 'botiga_section_single_product',
                'priority'	 	=> 150
            )
        )
    );

    $wp_customize->add_setting(
        'single_product_tabs_background_color',
        array(
            'default'           => '#f5f5f5',
            'sanitize_callback' => 'botiga_sanitize_hex_rgba',
            'transport'         => 'postMessage'
        )
    );
    $wp_customize->add_control(
        new Botiga_Alpha_Color(
            $wp_customize,
            'single_product_tabs_background_color',
            array(
                'label'         	=> esc_html__( 'Background Color', 'botiga-pro' ),
                'section'       	=> 'botiga_section_single_product',
                'active_callback'   => 'botiga_callback_single_tabs_background_color',
                'priority'	 		=> 150
            )
        )
    );

    $wp_customize->add_setting(
        'single_product_tabs_text_color',
        array(
            'default'           => '#212121',
            'sanitize_callback' => 'botiga_sanitize_hex_rgba',
            'transport'         => 'postMessage'
        )
    );
    $wp_customize->add_control(
        new Botiga_Alpha_Color(
            $wp_customize,
            'single_product_tabs_text_color',
            array(
                'label'         	=> esc_html__( 'Text Color', 'botiga-pro' ),
                'section'       	=> 'botiga_section_single_product',
                'priority'	 		=> 150
            )
        )
    );

    $wp_customize->add_setting( 
        'single_product_tabs_state_title2',
        array(
            'default' 			=> '',
            'sanitize_callback' => 'esc_attr'
        )
    );
    $wp_customize->add_control( 
        new Botiga_Text_Control( 
            $wp_customize, 
            'single_product_tabs_state_title2',
            array(
                'label'			=> esc_html__( 'Active State', 'botiga-pro' ),
                'section' 		=> 'botiga_section_single_product',
                'priority'	 	=> 150
            )
        )
    );

    $wp_customize->add_setting(
        'single_product_tabs_border_color_active',
        array(
            'default'           => '#212121',
            'sanitize_callback' => 'botiga_sanitize_hex_rgba',
            'transport'         => 'postMessage'
        )
    );
    $wp_customize->add_control(
        new Botiga_Alpha_Color(
            $wp_customize,
            'single_product_tabs_border_color_active',
            array(
                'label'         	=> esc_html__( 'Border Color', 'botiga-pro' ),
                'section'       	=> 'botiga_section_single_product',
                'active_callback'   => 'botiga_callback_single_tabs_border_color_active',
                'priority'	 		=> 150
            )
        )
    );

    $wp_customize->add_setting(
        'single_product_tabs_background_color_active',
        array(
            'default'           => '#f5f5f5',
            'sanitize_callback' => 'botiga_sanitize_hex_rgba',
            'transport'         => 'postMessage'
        )
    );
    $wp_customize->add_control(
        new Botiga_Alpha_Color(
            $wp_customize,
            'single_product_tabs_background_color_active',
            array(
                'label'         	=> esc_html__( 'Background Color', 'botiga-pro' ),
                'section'       	=> 'botiga_section_single_product',
                'active_callback'   => 'botiga_callback_single_tabs_background_color',
                'priority'	 		=> 150
            )
        )
    );

    $wp_customize->add_setting(
        'single_product_tabs_text_color_active',
        array(
            'default'           => '#212121',
            'sanitize_callback' => 'botiga_sanitize_hex_rgba',
            'transport'         => 'postMessage'
        )
    );
    $wp_customize->add_control(
        new Botiga_Alpha_Color(
            $wp_customize,
            'single_product_tabs_text_color_active',
            array(
                'label'         	=> esc_html__( 'Text Color', 'botiga-pro' ),
                'section'       	=> 'botiga_section_single_product',
                'priority'	 		=> 150
            )
        )
    );

    $wp_customize->add_setting(
        'single_product_tabs_remaining_borders',
        array(
            'default'           => '#212121',
            'sanitize_callback' => 'botiga_sanitize_hex_rgba',
            'transport'         => 'postMessage'
        )
    );
    $wp_customize->add_control(
        new Botiga_Alpha_Color(
            $wp_customize,
            'single_product_tabs_remaining_borders',
            array(
                'label'         	=> esc_html__( 'Remaining Borders Color', 'botiga-pro' ),
                'description'       => esc_html__( 'Also controls the horizontal line color in some layouts', 'botiga-pro' ),
                'section'       	=> 'botiga_section_single_product',
                'priority'	 		=> 150
            )
        )
    );

}
add_action( 'customize_register', 'botiga_pro_woocommerce_single', 999 );