<?php
/**
 * Header Customizer options
 *
 * @package Botiga_Pro
 */

/**
 * Extend header elements with new options
 */
function botiga_header_elements_pro() {
    $elements = array(
		'search' 			=> esc_html__( 'Search', 'botiga-pro' ),
		'woocommerce_icons' => esc_html__( 'Cart &amp; account icons', 'botiga-pro' ),
		'button' 			=> esc_html__( 'Button', 'botiga-pro' ),
		'contact_info' 		=> esc_html__( 'Contact info', 'botiga-pro' ),
        'html'              => esc_html__( 'HTML', 'botiga-pro' ),
        'shortcode'         => esc_html__( 'Shortcode', 'botiga-pro' )
	);

    if( class_exists( 'Woocommerce' ) ) {
        $elements['login_register'] = esc_html__( 'Login/Register', 'botiga-pro' );
    }

    return $elements;
}
add_filter( 'botiga_header_elements', 'botiga_header_elements_pro' );

function botiga_header_elements_layout_7_8_pro() {
    $elements = array(
		'search' 			=> esc_html__( 'Search', 'botiga-pro' ),
		'woocommerce_icons' => esc_html__( 'Cart &amp; account icons', 'botiga-pro' ),
		'button' 			=> esc_html__( 'Button', 'botiga-pro' ),
		'contact_info' 		=> esc_html__( 'Contact info', 'botiga-pro' ),
		'hamburger_btn'     => esc_html__( 'Hamburger button', 'botiga-pro' ),
        'html'              => esc_html__( 'HTML', 'botiga-pro' ),
        'shortcode'         => esc_html__( 'Shortcode', 'botiga-pro' )
	);

    if( class_exists( 'Woocommerce' ) ) {
        $elements['login_register'] = esc_html__( 'Login/Register', 'botiga-pro' );
    }

    return $elements;
}
add_filter( 'botiga_header_elements_layout_7_8', 'botiga_header_elements_layout_7_8_pro' );

/**
 * Extend header customizer with new features
 */
function botiga_pro_header_options( $wp_customize ) {
    
    // Tabs control
    $controls_general     = json_decode( $wp_customize->get_control( 'botiga_main_header_tabs' )->controls_general );
    $new_controls_general = array( '#customize-control-main_header_vertical_alignment_l6','#customize-control-main_header_content_alignment_l6','#customize-control-main_header_areas_spacing_l6','#customize-control-main_header_elements_spacing_l6','#customize-control-header_components_l7left','#customize-control-header_components_l7right','#customize-control-header_divider_8','#customize-control-main_header_desktop_offcanvas','#customize-control-desktop_offcanvas_hide_logo','#customize-control-header_components_desktop_offcanvas','#customize-control-header_components_desktop_offcanvas_elements_spacing','#customize-control-desktop_offcanvas_vertical_align','#customize-control-desktop_offcanvas_link_align','#customize-control-desktop_offcanvas_menu_link_separator','#customize-control-desktop_offcanvas_menu_link_spacing','#customize-control-desktop_offcanvas_content_areas_spacing','#customize-control-enable_header_wishlist_icon','#customize-control-header_divider_9','#customize-control-cart_icon','#customize-control-header_divider_account_icon','#customize-control-account_icon','#customize-control-header_divider_10','#customize-control-header_divider_11','#customize-control-header_shortcode_content_title','#customize-control-header_shortcode_content','#customize-control-header_divider_12','#customize-control-header_login_register_title','#customize-control-header_login_register_settings_link' );
    $wp_customize->get_control( 'botiga_main_header_tabs' )->controls_general = json_encode( array_merge( $controls_general, $new_controls_general ) );
    
    $controls_design     = json_decode( $wp_customize->get_control( 'botiga_main_header_tabs' )->controls_design );
    $new_controls_design = array( '#customize-control-main_header_divider_8','#customize-control-desktop_offcanvas_menu_title_1','#customize-control-desktop_offcanvas_menu_text_color','#customize-control-desktop_offcanvas_menu_background_color','#customize-control-desktop_offcanvas_link_separator_color','#customize-control-desktop_offcanvas_padding' );
    $wp_customize->get_control( 'botiga_main_header_tabs' )->controls_design = json_encode( array_merge( $controls_design, $new_controls_design ) );

    // Main Header
    $wp_customize->get_control( 'header_layout_desktop' )->choices = array(
        'header_layout_1' => array(
			'label' => esc_html__( 'Layout 1', 'botiga-pro' ),
			'url'   => '%s/assets/img/hl1.svg'
		),
		'header_layout_2' => array(
			'label' => esc_html__( 'Layout 2', 'botiga-pro' ),
			'url'   => '%s/assets/img/hl2.svg'
		),		
		'header_layout_3' => array(
			'label' => esc_html__( 'Layout 3', 'botiga-pro' ),
			'url'   => '%s/assets/img/hl3.svg'
		),				
		'header_layout_4' => array(
			'label' => esc_html__( 'Layout 4', 'botiga-pro' ),
			'url'   => '%s/assets/img/hl4.svg'
		),
		'header_layout_5' => array(
			'label' => esc_html__( 'Layout 5', 'botiga-pro' ),
			'url'   => '%s/assets/img/hl5.svg'
		),
        // Pro headers below
		'header_layout_6' => array(
			'label' => esc_html__( 'Layout 6', 'botiga-pro' ),
			'url'   => '%s/assets/img/hl6.svg'
		),
		'header_layout_7' => array(
			'label' => esc_html__( 'Layout 7', 'botiga-pro' ),
			'url'   => '%s/assets/img/hl7.svg'
		),
		'header_layout_8' => array(
			'label' => esc_html__( 'Layout 8', 'botiga-pro' ),
			'url'   => '%s/assets/img/hl8.svg'
		)
    );

    // Header layout 6
    $wp_customize->add_setting( 
        'main_header_vertical_alignment_l6',
        array(
            'default' 			=> 'top',
            'sanitize_callback' => 'botiga_sanitize_text'
        )
    );
    $wp_customize->add_control( 
        new Botiga_Radio_Buttons( 
            $wp_customize, 
            'main_header_vertical_alignment_l6',
            array(
                'label' 		=> esc_html__( 'Vertical Alignment', 'botiga-pro' ),
                'section' => 'botiga_section_main_header',
                'choices' => array(
                    'top' 		=> esc_html__( 'Top', 'botiga-pro' ),
                    'center' 	=> esc_html__( 'Center', 'botiga-pro' ),
                    'bottom' 	=> esc_html__( 'Bottom', 'botiga-pro' ),
                ),
                'active_callback' => 'botiga_callback_header_layout_is_6',
                'priority'		  => 41
            )
        ) 
    );

    $wp_customize->add_setting( 
        'main_header_content_alignment_l6',
        array(
            'default' 			=> 'left',
            'sanitize_callback' => 'botiga_sanitize_text'
        )
    );
    $wp_customize->add_control( 
        new Botiga_Radio_Buttons( 
            $wp_customize, 
            'main_header_content_alignment_l6',
            array(
                'label' 		=> esc_html__( 'Content Alignment', 'botiga-pro' ),
                'section' => 'botiga_section_main_header',
                'choices' => array(
                    'left' 		=> '<svg width="16" height="13" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M0 0h10v1H0zM0 4h16v1H0zM0 8h10v1H0zM0 12h16v1H0z"/></svg>',
                    'center' 	=> '<svg width="16" height="13" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M3 0h10v1H3zM0 4h16v1H0zM3 8h10v1H3zM0 12h16v1H0z"/></svg>',
                    'right' 	=> '<svg width="16" height="13" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M6 0h10v1H6zM0 4h16v1H0zM6 8h10v1H6zM0 12h16v1H0z"/></svg>',
                ),
                'active_callback' => 'botiga_callback_header_layout_is_6',
                'priority'		  => 41
            )
        ) 
    );

    $wp_customize->add_setting( 
        'main_header_areas_spacing_l6', 
        array(
            'default'   		=> 15,
            'transport'			=> 'postMessage',
            'sanitize_callback' => 'absint',
        ) 
    );			
    
    $wp_customize->add_control( 
        new Botiga_Responsive_Slider( 
            $wp_customize, 
            'main_header_areas_spacing_l6',
            array(
                'label' 		=> esc_html__( 'Content Areas Spacing', 'botiga-pro' ),
                'description'   => esc_html__( 'The spacing between logo, menu and elements.', 'botiga-pro' ),
                'section' 		=> 'botiga_section_main_header',
                'active_callback' => 'botiga_callback_header_layout_is_6',
                'is_responsive'	=> 0,
                'settings' 		=> array (
                    'size_desktop' 		=> 'main_header_areas_spacing_l6',
                ),
                'input_attrs' => array (
                    'min'	=> 0,
                    'max'	=> 100
                ),
                'priority' => 41
            )
        ) 
    );

    $wp_customize->add_setting( 
        'main_header_elements_spacing_l6', 
        array(
            'default'   		=> 15,
            'transport'			=> 'postMessage',
            'sanitize_callback' => 'absint',
        ) 
    );			
    
    $wp_customize->add_control( 
        new Botiga_Responsive_Slider( 
            $wp_customize, 
            'main_header_elements_spacing_l6',
            array(
                'label' 		=> esc_html__( 'Elements Spacing', 'botiga-pro' ),
                'section' 		=> 'botiga_section_main_header',
                'active_callback' => 'botiga_callback_header_layout_is_6',
                'is_responsive'	=> 0,
                'settings' 		=> array (
                    'size_desktop' 		=> 'main_header_elements_spacing_l6',
                ),
                'input_attrs' => array (
                    'min'	=> 0,
                    'max'	=> 100
                ),
                'priority' => 111
            )
        ) 
    );

    // Header layout 7
    $botiga_header_components_layout_7_8 = botiga_header_elements_layout_7_8();
    $botiga_default_components           = botiga_get_default_header_components();

    $wp_customize->add_setting( 
        'header_components_l7left', 
        array(
            'default'  			=> $botiga_default_components['l7left'],
            'sanitize_callback'	=> 'botiga_sanitize_header_components_layout_7_8'
        ) 
    );
    
    $wp_customize->add_control( 
        new \Kirki\Control\Sortable( 
            $wp_customize, 
            'header_components_l7left', 
            array(
                'label'   			=> esc_html__( 'Left Side', 'botiga-pro' ),
                'section' 			=> 'botiga_section_main_header',
                'choices' 			=> $botiga_header_components_layout_7_8,
                'active_callback' 	=> 'botiga_callback_header_layout_is_7',
                'priority'			=> 111
            ) 
        ) 
    );

    $wp_customize->add_setting( 
        'header_components_l7right', 
        array(
            'default'  			=> $botiga_default_components['l7right'],
            'sanitize_callback'	=> 'botiga_sanitize_header_components_layout_7_8'
        ) 
    );
    
    $wp_customize->add_control( 
        new \Kirki\Control\Sortable( 
            $wp_customize, 
            'header_components_l7right', 
            array(
                'label'   			=> esc_html__( 'Right Side', 'botiga-pro' ),
                'section' 			=> 'botiga_section_main_header',
                'choices' 			=> $botiga_header_components_layout_7_8,
                'active_callback' 	=> 'botiga_callback_header_layout_is_7_8',
                'priority'			=> 111
            ) 
        ) 
    );

    $wp_customize->add_setting( 'header_divider_8',
        array(
            'sanitize_callback' => 'esc_attr'
        )
    );
    $wp_customize->add_control( 
        new Botiga_Divider_Control( 
            $wp_customize, 
            'header_divider_8',
            array(
                'section' 		=> 'botiga_section_main_header',
                'active_callback' 	=> 'botiga_callback_header_layout_is_7_8',
                'priority'			=> 111
            )
        )
    );

    $wp_customize->add_setting(
        'main_header_desktop_offcanvas',
        array(
            'default'           => 'layout1',
            'sanitize_callback' => 'sanitize_key',
        )
    );
    $wp_customize->add_control(
        new Botiga_Radio_Images(
            $wp_customize,
            'main_header_desktop_offcanvas',
            array(
                'label'    	=> esc_html__( 'Desktop Offcanvas Mode', 'botiga-pro' ),
                'section'  	=> 'botiga_section_main_header',
                'cols'		=> 2,
                'choices'  => array(
                    'layout1' => array(
                        'label' => esc_html__( 'Layout 1', 'botiga-pro' ),
                        'url'   => '%s/assets/img/oc1.svg'
                    ),
                    'layout2' => array(
                        'label' => esc_html__( 'Layout 2', 'botiga-pro' ),
                        'url'   => '%s/assets/img/oc2.svg'
                    ),	
                ),
                'active_callback' 	=> 'botiga_callback_header_layout_is_7_8',
                'priority'			=> 111
            )
        )
    );

    $wp_customize->add_setting(
        'desktop_offcanvas_hide_logo',
        array(
            'default'           => 0,
            'sanitize_callback' => 'botiga_sanitize_checkbox',
        )
    );
    $wp_customize->add_control(
        new Botiga_Toggle_Control(
            $wp_customize,
            'desktop_offcanvas_hide_logo',
            array(
                'label'         	=> esc_html__( 'Hide Offcanvas Logo', 'botiga-pro' ),
                'section'       	=> 'botiga_section_main_header',
                'active_callback' 	=> 'botiga_callback_header_layout_is_7_8',
                'priority'			=> 111
            )
        )
    );

    $wp_customize->add_setting( 
        'header_components_desktop_offcanvas', 
        array(
            'default'  			=> $botiga_default_components['desktop_offcanvas'],
            'sanitize_callback'	=> 'botiga_sanitize_header_components_layout_7_8'
        ) 
    );
    
    $wp_customize->add_control( 
        new \Kirki\Control\Sortable( 
            $wp_customize, 
            'header_components_desktop_offcanvas', 
            array(
                'label'   			=> esc_html__( 'Additional Offcanvas Elements', 'botiga-pro' ),
                'section' 			=> 'botiga_section_main_header',
                'choices' 			=> $botiga_header_components_layout_7_8,
                'active_callback' 	=> 'botiga_callback_header_layout_is_7_8',
                'priority'			=> 111
            ) 
        ) 
    );

    $wp_customize->add_setting( 
        'header_components_desktop_offcanvas_elements_spacing', 
        array(
            'default'   		=> 15,
            'transport'			=> 'postMessage',
            'sanitize_callback' => 'absint',
        ) 
    );			
    
    $wp_customize->add_control( 
        new Botiga_Responsive_Slider( 
            $wp_customize, 
            'header_components_desktop_offcanvas_elements_spacing',
            array(
                'label' 		=> esc_html__( 'Elements Spacing', 'botiga-pro' ),
                'section' 		=> 'botiga_section_main_header',
                'active_callback' => 'botiga_callback_header_layout_is_7_8',
                'is_responsive'	=> 0,
                'settings' 		=> array (
                    'size_desktop' 		=> 'header_components_desktop_offcanvas_elements_spacing',
                ),
                'input_attrs' => array (
                    'min'	=> 0,
                    'max'	=> 100
                ),
                'priority' => 111
            )
        ) 
    );

    $wp_customize->add_setting( 
        'desktop_offcanvas_vertical_align',
        array(
            'default' 			=> 'center',
            'sanitize_callback' => 'botiga_sanitize_text'
        )
    );
    $wp_customize->add_control( 
        new Botiga_Radio_Buttons( 
            $wp_customize, 
            'desktop_offcanvas_vertical_align',
            array(
                'label' 		=> esc_html__( 'Vertical Alignment', 'botiga-pro' ),
                'section' => 'botiga_section_main_header',
                'choices' => array(
                    'top' 		=> esc_html__( 'Top', 'botiga-pro' ),
                    'center' 	=> esc_html__( 'Center', 'botiga-pro' ),
                    'bottom' 	=> esc_html__( 'Bottom', 'botiga-pro' ),
                ),
                'active_callback' => 'botiga_callback_header_layout_is_7_8',
                'priority'		  => 111
            )
        ) 
    );

    $wp_customize->add_setting( 
        'desktop_offcanvas_link_align',
        array(
            'default' 			=> 'center',
            'sanitize_callback' => 'botiga_sanitize_text'
        )
    );
    $wp_customize->add_control( 
        new Botiga_Radio_Buttons( 
            $wp_customize, 
            'desktop_offcanvas_link_align',
            array(
                'label'   => esc_html__( 'Link alignment', 'botiga-pro' ),
                'section' => 'botiga_section_main_header',
                'choices' => array(
                    'left' 		=> '<svg width="16" height="13" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M0 0h10v1H0zM0 4h16v1H0zM0 8h10v1H0zM0 12h16v1H0z"/></svg>',
                    'center' 	=> '<svg width="16" height="13" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M3 0h10v1H3zM0 4h16v1H0zM3 8h10v1H3zM0 12h16v1H0z"/></svg>',
                    'right' 	=> '<svg width="16" height="13" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M6 0h10v1H6zM0 4h16v1H0zM6 8h10v1H6zM0 12h16v1H0z"/></svg>',
                ),
                'active_callback' 	=> 'botiga_callback_header_layout_is_7_8',
                'priority'			=> 111
            )
        ) 
    );

    $wp_customize->add_setting(
        'desktop_offcanvas_menu_link_separator',
        array(
            'default'           => 0,
            'sanitize_callback' => 'botiga_sanitize_checkbox',
        )
    );
    $wp_customize->add_control(
        new Botiga_Toggle_Control(
            $wp_customize,
            'desktop_offcanvas_menu_link_separator',
            array(
                'label'         	=> esc_html__( 'Link separator', 'botiga-pro' ),
                'section'       	=> 'botiga_section_main_header',
                'active_callback' 	=> 'botiga_callback_header_layout_is_7_8',
                'priority'			=> 111
            )
        )
    );
    
    $wp_customize->add_setting( 
        'desktop_offcanvas_menu_link_spacing', array(
            'default'   		=> 10,
            'sanitize_callback' => 'absint',
            'transport'			=> 'postMessage'
        ) 
    );			
    
    $wp_customize->add_control( 
        new Botiga_Responsive_Slider( 
            $wp_customize, 
            'desktop_offcanvas_menu_link_spacing',
            array(
                'label' 		=> esc_html__( 'Link spacing', 'botiga-pro' ),
                'section' 		=> 'botiga_section_main_header',
                'is_responsive'	=> 0,
                'settings' 		=> array (
                    'size_desktop' 		=> 'desktop_offcanvas_menu_link_spacing',
                ),
                'input_attrs' => array (
                    'min'	=> 0,
                    'max'	=> 50,
                    'step'  => 1
                ),
                'active_callback' 	=> 'botiga_callback_header_layout_is_7_8',
                'priority'			=> 111
            )
        ) 
    );

    $wp_customize->add_setting( 
        'desktop_offcanvas_content_areas_spacing', 
        array(
            'default'   		=> 50,
            'transport'			=> 'postMessage',
            'sanitize_callback' => 'absint',
        ) 
    );			
    
    $wp_customize->add_control( 
        new Botiga_Responsive_Slider( 
            $wp_customize, 
            'desktop_offcanvas_content_areas_spacing',
            array(
                'label' 		=> esc_html__( 'Content Areas Spacing', 'botiga-pro' ),
                'description'   => esc_html__( 'The spacing between logo, menu and elements.', 'botiga-pro' ),
                'section' 		=> 'botiga_section_main_header',
                'active_callback' => 'botiga_callback_header_layout_is_7_8',
                'is_responsive'	=> 0,
                'settings' 		=> array (
                    'size_desktop' 		=> 'desktop_offcanvas_content_areas_spacing',
                ),
                'input_attrs' => array (
                    'min'	=> 0,
                    'max'	=> 100
                ),
                'priority' => 111
            )
        ) 
    );

    // Wishlist
    $wp_customize->add_setting(
        'enable_header_wishlist_icon',
        array(
            'default'           => 1,
            'sanitize_callback' => 'botiga_sanitize_checkbox',
        )
    );
    $wp_customize->add_control(
        new Botiga_Toggle_Control(
            $wp_customize,
            'enable_header_wishlist_icon',
            array(
                'label'         	=> esc_html__( 'Enable wishlist icon', 'botiga-pro' ),
                'section'       	=> 'botiga_section_main_header',
                'active_callback' 	=> 'botiga_callback_shop_product_wishlist_layout',
                'priority'			=> 221
            )
        )
    );

    // Divider
    $wp_customize->add_setting( 'header_divider_10',
        array(
            'sanitize_callback' => 'esc_attr'
        )
    );
    $wp_customize->add_control( new Botiga_Divider_Control( $wp_customize, 'header_divider_10',
            array(
                'section' 		  => 'botiga_section_main_header',
                'active_callback' => function() { return botiga_callback_header_elements( 'html' ); },
                'priority'        => 221
            )
        )
    );

    // Divider
    $wp_customize->add_setting( 'header_divider_11',
        array(
            'sanitize_callback' => 'esc_attr'
        )
    );
    $wp_customize->add_control( new Botiga_Divider_Control( $wp_customize, 'header_divider_11',
            array(
                'section' 		  => 'botiga_section_main_header',
                'active_callback' => function() { return botiga_callback_header_elements( 'shortcode' ); },
                'priority'        => 221
            )
        )
    );

    // Shortcode field content
    $wp_customize->add_setting( 
        'header_shortcode_content_title',
        array(
            'default' 			=> '',
            'sanitize_callback' => 'esc_attr'
        )
    );
    $wp_customize->add_control( 
        new Botiga_Text_Control( 
            $wp_customize, 
            'header_shortcode_content_title',
            array(
                'label'			  => esc_html__( 'Shortcode Tag', 'botiga-pro' ),
                'section' 		  => 'botiga_section_main_header',
                'active_callback' => function() { return botiga_callback_header_elements( 'shortcode' ); },
                'priority'	 	  => 221
            )
        )
    );

    $wp_customize->add_setting(
        'header_shortcode_content',
        array(
            'sanitize_callback' => 'botiga_sanitize_text',
            'default'           => '',
        )       
    );
    $wp_customize->add_control( 
        'header_shortcode_content', 
        array(
            'label'           => '',
            'type'            => 'text',
            'section'         => 'botiga_section_main_header',
            'active_callback' => function() { return botiga_callback_header_elements( 'shortcode' ); },
            'priority'        => 221
        ) 
    );

    if( class_exists( 'Woocommerce' ) ) {        
        // Divider
        $wp_customize->add_setting( 'header_divider_12',
            array(
                'sanitize_callback' => 'esc_attr'
            )
        );
        $wp_customize->add_control( new Botiga_Divider_Control( $wp_customize, 'header_divider_12',
                array(
                    'section' 		  => 'botiga_section_main_header',
                    'active_callback' => function() { return botiga_callback_header_elements( 'login_register' ); },
                    'priority'        => 221
                )
            )
        );

        // Login/register field
        $wp_customize->add_setting( 
            'header_login_register_title',
            array(
                'default' 			=> '',
                'sanitize_callback' => 'esc_attr'
            )
        );
        $wp_customize->add_control( 
            new Botiga_Text_Control( 
                $wp_customize, 
                'header_login_register_title',
                array(
                    'label'			  => esc_html__( 'Login/Register', 'botiga-pro' ),
                    'section' 		  => 'botiga_section_main_header',
                    'active_callback' => function() { return botiga_callback_header_elements( 'login_register' ); },
                    'priority'	 	  => 221
                )
            )
        );

        $wp_customize->add_setting( 
            'header_login_register_settings_link',
            array(
                'default' 			=> '',
                'sanitize_callback' => 'esc_attr'
            )
        );
    
        $wp_customize->add_control( 
            new Botiga_Text_Control( 
                $wp_customize, 
                'header_login_register_settings_link',
                array(
                    'label'           => '',
                    'description'     => '<a class="footer-widget-area-link footer-widget-area-link-1" href="javascript:wp.customize.section( \'botiga_login_register_popup\' ).focus();">' . esc_html__( 'Login/Register Settings', 'botiga-pro' ) . '<span class="dashicons dashicons-arrow-right-alt2"></span></a>',
                    'section' 		  => 'botiga_section_main_header',
                    'active_callback' => function() { return botiga_callback_header_elements( 'login_register' ); },
                    'priority'        => 221
                )
            )
        );
    }
    
    /**
     * Design
     */
    $wp_customize->add_setting( 
        'main_header_divider_8',
        array(
            'sanitize_callback' => 'esc_attr'
        )
    );

    $wp_customize->add_control( 
        new Botiga_Divider_Control( 
            $wp_customize, 
            'main_header_divider_8',
            array(
                'section' 			=> 'botiga_section_main_header',
                'active_callback' => 'botiga_callback_header_layout_is_7_8',
                'priority'			=> 441
            )
        )
    );

    $wp_customize->add_setting( 
        'desktop_offcanvas_menu_title_1',
        array(
            'default' 			=> '',
            'sanitize_callback' => 'esc_attr'
        )
    );

    $wp_customize->add_control( 
        new Botiga_Text_Control( 
            $wp_customize, 
            'desktop_offcanvas_menu_title_1',
            array(
                'label'			=> esc_html__( 'Desktop Offcanvas Menu', 'botiga-pro' ),
                'section' 		=> 'botiga_section_main_header',
                'active_callback'   => 'botiga_callback_header_layout_is_7_8',
                'priority'		=> 441
            )
        )
    );

    $wp_customize->add_setting(
        'desktop_offcanvas_menu_text_color',
        array(
            'default'           => '#212121',
            'sanitize_callback' => 'botiga_sanitize_hex_rgba',
            'transport'         => 'postMessage'
        )
    );
    $wp_customize->add_control(
        new Botiga_Alpha_Color(
            $wp_customize,
            'desktop_offcanvas_menu_text_color',
            array(
                'label'         	=> esc_html__( 'Text Color', 'botiga-pro' ),
                'section'       	=> 'botiga_section_main_header',
                'active_callback'   => 'botiga_callback_header_layout_is_7_8',
                'priority'			=> 441
            )
        )
    );

    $wp_customize->add_setting(
        'desktop_offcanvas_menu_background_color',
        array(
            'default'           => '#fff',
            'sanitize_callback' => 'botiga_sanitize_hex_rgba',
            'transport'         => 'postMessage'
        )
    );
    $wp_customize->add_control(
        new Botiga_Alpha_Color(
            $wp_customize,
            'desktop_offcanvas_menu_background_color',
            array(
                'label'         	=> esc_html__( 'Background Color', 'botiga-pro' ),
                'section'       	=> 'botiga_section_main_header',
                'active_callback'   => 'botiga_callback_header_layout_is_7_8',
                'priority'			=> 441
            )
        )
    );

    $wp_customize->add_setting(
        'desktop_offcanvas_link_separator_color',
        array(
            'default'           => '#212121',
            'sanitize_callback' => 'botiga_sanitize_hex_rgba',
            'transport'         => 'postMessage'
        )
    );
    $wp_customize->add_control(
        new Botiga_Alpha_Color(
            $wp_customize,
            'desktop_offcanvas_link_separator_color',
            array(
                'label'         	=> esc_html__( 'Link Separator Color', 'botiga-pro' ),
                'section'       	=> 'botiga_section_main_header',
                'active_callback'   => 'botiga_callback_header_layout_is_7_8',
                'priority'			=> 441
            )
        )
    );

    $wp_customize->add_setting( 
        'desktop_offcanvas_padding', array(
            'default'   		=> 30,
            'transport'			=> 'postMessage',
            'sanitize_callback' => 'absint',
        ) 
    );			
    
    $wp_customize->add_control( 
        new Botiga_Responsive_Slider( 
            $wp_customize, 
            'desktop_offcanvas_padding',
            array(
                'label' 		  => esc_html__( 'Padding', 'botiga-pro' ),
                'section' 		  => 'botiga_section_main_header',
                'active_callback' => 'botiga_callback_header_layout_is_7_8',
                'is_responsive'	  => 0,
                'settings' 		  => array (
                    'size_desktop' 		=> 'desktop_offcanvas_padding',
                ),
                'input_attrs'     => array (
                    'min'	=> 0,
                    'max'	=> 100
                ),
                'priority'		  => 441
            )
        ) 
    );
    
}
add_action( 'customize_register', 'botiga_pro_header_options', 999 );

/**
 * Extend secondary menu customizer for display conditions
 */
function botiga_pro_header_secondary_options( $wp_customize ) {
    
    // Secondary Menu Controls
    if( isset( $wp_customize->get_control( 'botiga_section_hb_component__secondary_menu_tabs' )->controls_general ) ) {
        $controls_general     = json_decode( $wp_customize->get_control( 'botiga_section_hb_component__secondary_menu_tabs' )->controls_general );
        $new_controls_general = array( '#customize-control-secondary_menu_display_conditions' );
        $wp_customize->get_control( 'botiga_section_hb_component__secondary_menu_tabs' )->controls_general = json_encode( array_merge( $controls_general, $new_controls_general ) );
    }

    // Display Conditions
    $wp_customize->add_setting(
        'secondary_menu_display_conditions',
        array(
            'default'           => '[{"type":"include","condition":"all","id":null}]',
            'sanitize_callback' => 'sanitize_textarea_field'
        )
    );
    $wp_customize->add_control(
        new Botiga_Display_Conditions_Control(
            $wp_customize,
            'secondary_menu_display_conditions',
            array(
                'label'    => esc_html__( 'Display Conditions', 'botiga' ),
                'section'  => 'botiga_section_hb_component__secondary_menu',
                'priority' => 240,
            )
        )
    );
}
add_action( 'customize_register', 'botiga_pro_header_secondary_options', 1001 );