<?php
/**
 * Blog Archive Customizer options
 *
 * @package Botiga_Pro
 */

function botiga_pro_blog_archive_options( $wp_customize ) {
    /**
     * Tabs Control
     */
    $controls_general     = json_decode( $wp_customize->get_control( 'botiga_blog_archive_tabs' )->controls_general );
    $new_controls_general = array( '#customize-control-blog_archive_pagination_divider1','#customize-control-blog_archive_pagination_title','#customize-control-blog_archive_pagination_type','#customize-control-blog_archive_sidebar' );
    $wp_customize->get_control( 'botiga_blog_archive_tabs' )->controls_general = json_encode( array_merge( $controls_general, $new_controls_general ) );
    
    $controls_design     = json_decode( $wp_customize->get_control( 'botiga_blog_archive_tabs' )->controls_design );
    $new_controls_design = array( '' );
    $wp_customize->get_control( 'botiga_blog_archive_tabs' )->controls_design = json_encode( array_merge( $controls_design, $new_controls_design ) );

    // Pagination Type
    $wp_customize->add_setting( 'blog_archive_pagination_divider1',
        array(
            'sanitize_callback' => 'esc_attr'
        )
    );
    $wp_customize->add_control( 
        new Botiga_Divider_Control( 
            $wp_customize, 
            'blog_archive_pagination_divider1',
            array(
                'section' 		    => 'botiga_section_blog_archives',
                'priority' 		    => 331
            )
        )
    );

    $wp_customize->add_setting( 
        'blog_archive_pagination_title',
        array(
            'default' 			=> '',
            'sanitize_callback' => 'esc_attr'
        )
    );
    $wp_customize->add_control( 
        new Botiga_Text_Control( 
            $wp_customize, 
            'blog_archive_pagination_title',
            array(
                'label'			  => esc_html__( 'Pagination', 'botiga-pro' ),
                'section' 		  => 'botiga_section_blog_archives',
                'priority'	 	  => 331
            )
        )
    );

    $wp_customize->add_setting( 
        'blog_archive_pagination_type', 
        array(
            'sanitize_callback' => 'botiga_sanitize_select',
            'default' 			=> 'default'
        ) 
    );
    $wp_customize->add_control( 
        'blog_archive_pagination_type', 
        array(
            'type' 		=> 'select',
            'section' 	=> 'botiga_section_blog_archives',
            'label' 	=> esc_html__( 'Type', 'botiga-pro' ),
            'choices'   => array(
                'default' 		  => esc_html__( 'Default', 'botiga-pro' ),
                'load-more' 	  => esc_html__( 'Load More Button', 'botiga-pro' ),
                'infinite-scroll' => esc_html__( 'Infinite Scroll', 'botiga-pro' ),
            ),
            'priority'  => 331
        ) 
    );

    // Blog Sidebar
    $wp_customize->add_setting( 
        'blog_archive_sidebar', 
        array(
            'default'           => '',
            'sanitize_callback' => 'botiga_sanitize_select',
        ) 
    );
    $wp_customize->add_control( 
        'blog_archive_sidebar', 
        array(
            'type'            => 'select',
            'section'         => 'botiga_section_blog_archives',
            'label'           => esc_html__( 'Sidebar', 'botiga-pro' ),
            'choices'         => botiga_pro_get_registered_sidebars(),
            'active_callback' => 'botiga_callback_sidebar_archives',
            'priority'        => 41,
        ) 
    );
}
add_action( 'customize_register', 'botiga_pro_blog_archive_options', 999 );