<?php

/**
 *
 * @link              http://athemes.com
 * @since             1.0
 * @package           Botiga_Pro
 *
 * @wordpress-plugin
 * Plugin Name:       Botiga Pro
 * Description:       Provides enhancements for the Botiga WordPress theme
 * Version:           1.1.7
 * Author:            aThemes
 * Author URI:        http://athemes.com
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       botiga-pro
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}
update_option( 'botiga_pro_license_key', '******************' );
update_option( 'botiga_pro_license_status', 'valid' );
$theme  = wp_get_theme();
$parent = wp_get_theme()->parent();

if ( ($theme != 'Botiga' ) && ($parent != 'Botiga') )
    return;

/**
 * Set up and initialize
 */
class Botiga_Pro {

	private static $instance;

	/**
	 * Returns the instance.
	 */
	public static function get_instance() {
		if ( ! self::$instance )
			self::$instance = new self;
			
		return self::$instance;
	}

	/**
	 * Actions setup
	 */
	public function __construct() {
		add_action( 'init', array( $this, 'translation' ) );	
		add_action( 'plugins_loaded', array( $this, 'constants' ), 2 );	
		add_action( 'after_setup_theme', array( $this, 'pro_setup' ), 11 );	
		add_action( 'init', array( $this, 'includes' ), 10 );
		add_action( 'widgets_init', array( $this, 'botiga_pro_widgets_init' ) );
		add_filter( 'botiga_dashboard_settings', array( $this, 'pro_dashboard_settings' ), 11 );
		add_filter( 'atss_register_demos_settings', array( $this, 'pro_dashboard_settings' ), 11 );
		add_filter( 'body_class', array( $this, 'body_class' ) );
	}

	/**
	 * Constants
	 */
	public function constants() {
		define( 'ATHEMES_STORE_URL', 'http://athemes.com' );
		define( 'ATHEMES_PLUGIN_NAME', 'Botiga Pro' );
		define( 'BOTIGA_PRO_VERSION', '1.1.7' );
		define( 'BOTIGA_PRO_DIR', trailingslashit( plugin_dir_path( __FILE__ ) ) );
		define( 'BOTIGA_PRO_URI', trailingslashit( plugin_dir_url( __FILE__ ) ) );
		define( 'BOTIGA_TEMPLATE_DEBUG_MODE', FALSE );
	}  

	/**
	 * Pro dashboard settings
	 */
	public function pro_dashboard_settings( $settings ) {

		$settings['has_pro']           = true;
		$settings['changelog_version'] = BOTIGA_PRO_VERSION;
		$settings['changelog_link']    = 'https://athemes.com/changelog/botiga/';
		$settings['support_link']      = 'https://athemes.com/support/';

		return $settings;

	}

	/**
	 * Translation
	 */
	public function translation() {
		load_plugin_textdomain( 'botiga-pro', false, dirname( plugin_basename( __FILE__ ) ) . '/languages' ); 
	}

	/**
	 * Botiga pro setup
	 */
	public function pro_setup() {

		// Helpers
		require BOTIGA_PRO_DIR . 'inc/helpers.php';

		// Add image sizes
		add_image_size( 'botiga-header-icons', 50, 50, true );

		// Register nav menus
		register_nav_menus(
			array(
				'mobile'                => esc_html__( 'Primary - Mobile', 'botiga-pro' ),
				'top-bar-mobile'        => esc_html__( 'Secondary Menu - Mobile', 'botiga-pro' ),
				'footer-copyright-menu'	=> esc_html__( 'Footer Copyright Menu', 'botiga-pro' )
			)
		);

		// Register woocommerce product swatch widget
		if( class_exists( 'Woocommerce' ) ) {
			require_once( BOTIGA_PRO_DIR . '/inc/modules/product-swatches/product-swatches-widget.php' );
		}
	}

	/**
	 * Includes
	 */
	public function includes() {

		//Backward compatibility
		require_once( BOTIGA_PRO_DIR . 'inc/backward-compatibility.php' );
		
		//Customizer extra options
		if( is_customize_preview() ) {
			require_once( BOTIGA_PRO_DIR . 'inc/customizer/customizer.php' );
		}

		// Metabox
		require BOTIGA_PRO_DIR . 'inc/classes/class-botiga-single-sidebar-metabox.php';

		//General features
		require_once( BOTIGA_PRO_DIR . 'inc/general.php' );
		
		//WooCommerce features
		if( class_exists( 'Woocommerce' ) ) {
			require_once( BOTIGA_PRO_DIR . 'inc/woocommerce.php' );
		}

		// Modules
		require_once( BOTIGA_PRO_DIR . 'inc/modules/hf-builder/hf-builder.php' );
		require_once( BOTIGA_PRO_DIR . 'inc/modules/mega-menu/class-mega-menu.php' );
		require_once( BOTIGA_PRO_DIR . 'inc/modules/breadcrumbs/breadcrumbs.php' );
		require_once( BOTIGA_PRO_DIR . 'inc/modules/quick-links/quick-links.php' );
		require_once( BOTIGA_PRO_DIR . 'inc/modules/templates-builder/templates-builder.php' );
		require_once( BOTIGA_PRO_DIR . 'inc/modules/custom-fonts/custom-fonts.php' );
		require_once( BOTIGA_PRO_DIR . 'inc/modules/custom-sidebars/custom-sidebars.php' );
		require_once( BOTIGA_PRO_DIR . 'inc/modules/table-of-contents/table-of-contents.php' );
		require_once( BOTIGA_PRO_DIR . 'inc/modules/modal-popup/modal-popup.php' );

		// WooCommerce Modules
		if( class_exists( 'Woocommerce' ) ) {
			require_once( BOTIGA_PRO_DIR . 'inc/modules/wishlist/wishlist.php' );
			require_once( BOTIGA_PRO_DIR . 'inc/modules/size-chart/size-chart.php' );
			require_once( BOTIGA_PRO_DIR . 'inc/modules/video-gallery/video-gallery.php' );
			require_once( BOTIGA_PRO_DIR . 'inc/modules/advanced-reviews/advanced-reviews.php' );
			require_once( BOTIGA_PRO_DIR . 'inc/modules/product-swatches/product-swatches.php' );
			require_once( BOTIGA_PRO_DIR . 'inc/modules/linked-variations/linked-variations.php' );
			require_once( BOTIGA_PRO_DIR . 'inc/modules/variations-gallery/variations-gallery.php' );
			require_once( BOTIGA_PRO_DIR . 'inc/modules/sticky-add-to-cart/sticky-add-to-cart.php' );
			require_once( BOTIGA_PRO_DIR . 'inc/modules/quantity-step-control/quantity-step-control.php' );
			require_once( BOTIGA_PRO_DIR . 'inc/modules/google-autocomplete/google-autocomplete.php' );
		}

		//Updates
		if( is_admin() && ! defined( 'BOTIGA_AWL_ACTIVE' ) ) {
			if ( defined( 'BOTIGA_VERSION' ) && version_compare( BOTIGA_VERSION, '2.0.1', '>=' ) ) {
				require_once( BOTIGA_PRO_DIR . 'inc/license.php' );
			} else {
				require_once( BOTIGA_PRO_DIR . 'updates.php' );
			}
		}
	}

	/**
	 * Add 'bp' class to the body. 
	 * Used to determine if the theme is running Botiga Pro or not.
	 * 
	 */
	public function body_class( $classes ) {
        $classes[] = 'bp';

        return $classes;
    }

	/**
	 * Register widget area.
	 *
	 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
	 */
	public function botiga_pro_widgets_init() {
		
		// Custom Sidebars
		$enable_sidebars = class_exists( 'Botiga_Modules' ) ? Botiga_Modules::is_module_active( 'custom-sidebars' ) : '';
		$custom_sidebars = json_decode( get_theme_mod( 'custom_sidebars', '[]' ), true );

		if ( ! empty( $enable_sidebars ) && ! empty( $custom_sidebars ) ) {

			foreach ( $custom_sidebars as $custom_sidebar ) {

				if ( empty( $custom_sidebar['name'] ) ) {
					continue;
				}

				register_sidebar( array(
					'name'           => esc_html( $custom_sidebar['name'] ),
					'id'             => sanitize_key( $custom_sidebar['name'] ),
					'description'    => esc_html__( 'Add widgets here.', 'botiga-pro' ),
					'before_widget'  => '<section id="%1$s" class="widget %2$s">',
					'after_widget'   => '</section>',
					'before_title'   => '<h2 class="widget-title">',
					'after_title'    => '</h2>',
					'before_sidebar' => '<div class="sidebar-wrapper"><a href="#" role="button" class="close-sidebar" title="'. esc_attr__( 'Close sidebar', 'botiga-pro' ) .'" onclick="botiga.toggleClass.init(event, this, \'sidebar-slide-close\');" data-botiga-selector=".sidebar-slide+.widget-area" data-botiga-toggle-class="show">'. botiga_pro_get_svg_icon( 'icon-cancel' ) .'</a>',
					'after_sidebar'  => '</div>'
				) );

			}
		
		}

		// Shop Sidebar
		register_sidebar(
			array(
				'name'           => esc_html__( 'Shop Sidebar', 'botiga-pro' ),
				'id'             => 'shop-sidebar-1',
				'description'    => esc_html__( 'Add widgets here.', 'botiga-pro' ),
				'before_widget'  => '<section id="%1$s" class="widget %2$s">',
				'after_widget'   => '</section>',
				'before_title'   => '<h2 class="widget-title">',
				'after_title'    => '</h2>',
				'before_sidebar' => '<div class="sidebar-wrapper"><a href="#" role="button" class="close-sidebar" title="'. esc_attr__( 'Close sidebar', 'botiga-pro' ) .'" onclick="botiga.toggleClass.init(event, this, \'sidebar-slide-close\');" data-botiga-selector=".sidebar-slide+.widget-area" data-botiga-toggle-class="show">'. botiga_pro_get_svg_icon( 'icon-cancel' ) .'</a>',
				'after_sidebar'  => '</div>'
			)
		);

	}

}
Botiga_Pro::get_instance();

/**
 * Updates
 */
if( ! class_exists( 'EDD_SL_Plugin_Updater' ) && ! defined( 'BOTIGA_AWL_ACTIVE' ) ) {
    include( plugin_dir_path( __FILE__ ) . '/EDD_SL_Plugin_Updater.php' );
}

function botiga_pro_plugin_updater() {
	if( defined( 'BOTIGA_AWL_ACTIVE' ) ) {
		return;
	}

    $license_key = trim( get_option( 'botiga_pro_license_key' ) );
	$item_name   = get_option( 'botiga_pro_license_item_name', 'Botiga Pro' );

    // setup the updater
    $edd_updater = new EDD_SL_Plugin_Updater( ATHEMES_STORE_URL, __FILE__, array(
            'version'   => BOTIGA_PRO_VERSION,
            'license'   => $license_key,
            'item_name' => $item_name,
            'author'    => 'aThemes'
        )
    );
}
add_action( 'admin_init', 'botiga_pro_plugin_updater', 0 );