/**
 * Botiga Video Gallery
 * 
 * jQuery dependent: true
 * 
 */

'use strict';

var botiga = botiga || {};

botiga.videoGallery = {

    init: function() {

        var $prevSlide;

        jQuery(document).on('wc-product-gallery-before-init', '.woocommerce-product-gallery', function( event, gallery ) {

            var $gallery = jQuery(gallery);

            if ( ! $gallery.hasClass('botiga-product-video-gallery') ) {
                return;
            }

            wc_single_product_params.zoom_enabled = false;

            wc_single_product_params.flexslider.before = function( slider ) {
                $prevSlide = slider.slides.eq( slider.currentSlide );
            };

            wc_single_product_params.flexslider.after = function( slider ) {

                if ( $prevSlide.data('video') === 'oembed' ) {

                    var $frame = $prevSlide.find('iframe');

                    if ( $frame.length ) {

                        // Fix lazyload.
                        if ( $frame.data('src') ) {
                            $frame.attr('src', $frame.data('src'));
                        }

                        $frame.find('iframe').remove();
                        $frame.parent().append( $frame );
                        
                    }

                } else if ( $prevSlide.data('video') === 'html5' ) {

                    var $html5 = $prevSlide.find('video,audio');

                    if ( $html5.length ) {
                        $html5.get(0).pause();
                    }

                }

            };

        });

        jQuery(document).on('wc-product-gallery-after-init', '.woocommerce-product-gallery', function( event, gallery ) {

            var $gallery = jQuery(gallery);

            if ( ! $gallery.hasClass('botiga-product-video-gallery') ) {
                return;
            }

            var flexdata = $gallery.data('product_gallery');

            if ( ! flexdata || ! flexdata.$images ) {
                return;
            }

            var $flexItems     = flexdata.$images;
            var $flexThumbs    = $gallery.find('.flex-control-thumbs');
            var $flexThumbList = $flexThumbs.find('li');

            $flexItems.each( function() {

                var $flexItem = jQuery(this);

                if ( $flexItem.data('video') ) {
                    $flexThumbList.eq( $flexItem.index() ).addClass('botiga-flex-video-thumb');
                }

            });

            $gallery.find('.flex-control-nav').removeClass('flex-control-nav');

        });

    },

}

botiga.videoGallery.init();