/**
* Reviews Advanced
* 
* jQuery dependent: true
*/

'use strict';

var botiga = botiga || {};

botiga.reviewsAdvanced = {
    init: function() {
        const 
            _this       = this,
            modal       = document.getElementsByClassName( 'botiga-adv-reviews-modal' )[0],
            modalClose  = document.getElementsByClassName( 'botiga-adv-reviews-modal-close' )[0],
            writeButton = document.getElementsByClassName( 'botiga-adv-review-write-button' )[0];

        if( typeof writeButton === 'undefined' ) {
            return false;
        }

        writeButton.addEventListener( 'click', this.toggleModalDisplay );
        modalClose.addEventListener( 'click', this.toggleModalDisplay );
        modal.addEventListener( 'click', function(e){
            if( e.target.closest( '.botiga-adv-reviews-modal-body' ) !== null ) {
                return false;
            }

            _this.toggleModalDisplay();
        } );

        this.tabsBehavior();

        window.addEventListener( 'botiga.shop.single.reviews.pagination.initialized', function(){
            const last_nav_item = document.querySelectorAll( '.woocommerce-pagination > ul > li:last-child > span' );

            if( ! last_nav_item.length ) {
                return false;
            }

            if( last_nav_item[0].classList.contains( 'current' ) ) {
                const pag_wrapper = document.getElementsByClassName( 'botiga-pagination-wrapper' )[0];

                if( typeof pag_wrapper === 'undefined' ) {
                    return false;
                }

                pag_wrapper.remove();
            }
        } );
       
    },

    toggleModalDisplay: function() {
        const modal = document.getElementsByClassName( 'botiga-adv-reviews-modal' )[0];
        event.preventDefault();

        modal.classList.toggle( 'show' );
    },

    // Change tabs behavior when a comment is sent
    tabsBehavior: function() {
        const 
            hash = window.location.hash,
            url  = window.location.href;

        if( hash.toLowerCase().indexOf( 'comment-' ) == 0 && hash !== '#reviews' && hash !== '#tab-reviews' && url.indexOf( 'comment-page-' ) == 0 && url.indexOf( 'cpage=' ) == 0 ) {
            return false;
        }

        (function($){
            $( 'body' )
                // Tabs
                .on( 'init', '.wc-tabs-wrapper, .woocommerce-tabs', function() {
                    var $tabs        = $( this ).find( '.wc-tabs, ul.tabs' ).first();
                    var $tab_content = $( this ).find( '.wc-tab' ).first();

                    if ( hash.toLowerCase().indexOf( 'comment-' ) >= 0 || hash === '#reviews' || hash === '#tab-reviews' ) {
                        $tabs.find( 'li:first a' ).trigger( 'click' );
                        setTimeout(function(){
                            $tab_content.show();
                        }, 500);
                    } else if ( url.indexOf( 'comment-page-' ) > 0 || url.indexOf( 'cpage=' ) > 0 ) {
                        $tabs.find( 'li:first a' ).trigger( 'click' );
                        setTimeout(function(){
                            $tab_content.show();
                        }, 500);
                    }
                });
        })(jQuery);
    }

}

jQuery( document ).ready(function(){
    botiga.reviewsAdvanced.init();
} );