/**
 * Botiga Masonry Layout
 * 
 * jQuery dependent: true
 * 
 */

'use strict';

var botiga = botiga || {};

botiga.masonryLayout = {

    init: function() {
        
        var self     = this;
        var $masonry = jQuery('.product-masonry');
        var $wrapper = $masonry.find('.products');

        if ( ! $masonry.length || ! $wrapper.length ) {
            return;
        }

        $wrapper.addClass('masonry');

        jQuery(window).on('resize botiga.masonry', function() {
            if ( $wrapper.hasClass('masonry') ) {
                self.layout( $masonry );
            }
        }).trigger('botiga.masonry');

    },
    
    layout: function( $masonry ) {

        var $wrapper    = $masonry.find('.products');
        var $products   = $masonry.find('.product');
        var itemColumns = $wrapper.css('grid-template-columns').split(' ').length;
        var itemGap     = parseInt( $wrapper.css('gap') );
        var itemWidth   = (100 / itemColumns);
        var itemSpacing = (itemGap / itemColumns) * (itemColumns-1);

        $products.css({
            'width': 'calc('+ itemWidth +'% - '+ itemSpacing +'px)',
            'margin-bottom': itemGap,
        });

        $wrapper.masonry({
            itemSelector: '.product',
            gutter: itemGap,
        });

        $wrapper.masonry('layout');
    
    },

}

jQuery( document ).ready(function(){
    botiga.masonryLayout.init();
} );