/**
 * Botiga Grid List View
 * 
 * jQuery dependent: true
 * 
 */

'use strict';

var botiga = botiga || {};

botiga.gridListView = {

    init: function() {
        
        var self      = this;
        var $wrapper  = jQuery('main#primary');
        var $view     = $wrapper.find('.botiga-grid-list-view');
        var tempLayout;

        if ( ! $view.length ) {
            return;
        }

        $view.find('a').on('click', function( e ) {

            e.preventDefault();

            var $button   = jQuery(this);
            var layout    = $button.data('layout');
            var $products = $wrapper.find('.products');

            if ( ! $button.hasClass('active') ) {

                $products.addClass('loading');

                var url = new URL( window.location.href );

                if ( url.searchParams.get('view') ) {
                    url.searchParams.set('view', layout);
                } else {
                    url.searchParams.append('view', layout);
                }

                jQuery.get(url, function( html ) {

                    $products.empty();

                    $products.append( jQuery(html).find('.products > .product') );

                    $products.removeClass('loading');

                    $wrapper.removeClass('product-grid product-masonry product-list').addClass( layout );

                    if ( $products.hasClass('masonry') ) {
                        $products.removeClass('masonry');
                        $products.removeData('masonry');
                        $products.removeAttr('style');
                    }

                    self.maybeInitExtraFeatures( $wrapper, layout );

                });

                $button.addClass('active').siblings().removeClass('active');

            }

        });

    },

    maybeInitExtraFeatures: function( $wrapper, layout ) {

        // Pagination
        var $pagination = $wrapper.find('.botiga-pagination-button');

        if ( $pagination.length ) {

            if ( $pagination.data('pagination-type') === 'infinite-scroll' || $pagination.data('pagination-type') === 'load-more' ) {

                var $pages = $wrapper.find('.woocommerce-pagination a.page-numbers');

                $pages.each(function() {

                    var $page = jQuery(this);
                    var url = new URL( $page.attr('href') );

                    if ( url.searchParams.get('view') ) {
                        url.searchParams.set('view', layout);
                    } else {
                        url.searchParams.append('view', layout);
                    }

                    $page.attr('href', url);

                });

            }

        }

        // Masonry
        if ( layout === 'product-masonry' ) {

            var $products = $wrapper.find('.products');

            $products.addClass('masonry');
            $products.removeData('masonry');

            botiga.masonryLayout.init();

        }

        // Quick View
        if ( jQuery( '.botiga-quick-view-popup' ).length ) {
            botiga.quickView.init();
        }

        // Wishlist
        if ( jQuery( '.botiga-wishlist-button' ).length ) {
            botiga.wishList.init();
        }

        // AddToAny Share Buttons
        if ( typeof a2a !== 'undefined' ) {
            a2a.init_all();
        }

    },
}

jQuery( document ).ready(function(){
    botiga.gridListView.init();
} );