(function ($) {

	'use strict';

	window.botigaProductVariationGallery = {

		init: function () {

			$(document).on('click', '.woocommerce_variation', function () {

				var $variation = $(this);
				var wpMediaFrame;

				if (!$variation.data('init')) {

					var $gallery = $variation.find('.botiga-variation-gallery');
					var $sortable = $variation.find('.botiga-variation-gallery-sortable');
					var $input = $variation.find(':input').first();

					$sortable.sortable({
						helper: 'original',
						cursor: 'move',
						placeholder: 'widget-placeholder',
						update: function () {
							$input.trigger('change');
						}
					});

					$variation.find('.variable_pricing').prev().before($gallery);

					$gallery.on('click', '.botiga-add-item', function (e) {

						e.preventDefault();

						var $button = $(this);
						var loopId = $button.data('loop');

						if (wpMediaFrame) {
							wpMediaFrame.open();
							return;
						}

						wpMediaFrame = window.wp.media({
							library: {
								type: 'image',
							},
							multiple: true,
							button: {
								text: $button.data('button-text'),
							}
						});

						wpMediaFrame.on('select', function () {

							var selection = wpMediaFrame.state().get('selection').toJSON();

							var selectedIds = selection.map(function (attachment) {

								var thumbnail;

								if (attachment && attachment.sizes && attachment.sizes.thumbnail) {
									thumbnail = attachment.sizes.thumbnail.url;
								} else {
									thumbnail = attachment.url;
								}

								var item = '';
								item += '<li>';
								item += '<figure><img src="' + thumbnail + '" /></figure>';
								item += '<span class="botiga-remove-item dashicons dashicons-no"></span>';
								item += '<input type="hidden" name="botiga_variation_gallery[' + loopId + '][]" value="' + attachment.id + '" />';
								item += '</li>';

								$sortable.append(item);


								return attachment.id;

							});

							$input.trigger('change');

						});

						wpMediaFrame.open();

					});

					$gallery.on('click', '.botiga-remove-item', function () {

						$input.trigger('change');

						$(this).closest('li').remove();

					});

					$variation.data('init', true);

				}

			});

		},

	};

	$(document).ready(function () {
		botigaProductVariationGallery.init();
	});

})(jQuery);